package com.seatel.mobilehall.util.customview

import android.animation.ObjectAnimator
import android.content.Context
import android.os.Handler
import android.text.TextUtils
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.view.animation.DecelerateInterpolator
import android.widget.RelativeLayout
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ViewListSubscriptionPostpaidCircleBalancesBinding
import com.seatel.mobilehall.ui.profile.model.BalancesPostPaidModel
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils
import java.text.DecimalFormat

class ListSubscriptionPostPaidCircleBalancesView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : RelativeLayout(context, attrs, defStyleAttr) {

    private lateinit var binding: ViewListSubscriptionPostpaidCircleBalancesBinding

    init {
        // Initialize ViewBinding
        binding = ViewListSubscriptionPostpaidCircleBalancesBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setDataDisplay(data: BalancesPostPaidModel, isTopup: Boolean = false) {
        val decimalFormat = DecimalFormat("#.##")
        binding.ctvNameBalance.text = data.name

        if (isTopup) {
            binding.viewTopupBalanceNoCircle.visibility = View.VISIBLE
            binding.layoutProgressBar.visibility = View.INVISIBLE
            binding.viewRenewDate.visibility = View.GONE
            binding.balanceAmount.text = "$${decimalFormat.format(data.balance)}"
            if (data.expiredDate.isNullOrEmpty() || TextUtils.equals(data.expiredDate, "null")) {
                binding.viewExpiredDate.visibility = View.GONE
            } else {
                binding.ctvDateExpired.text = SeatelUtils.getDateTime(
                    "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Constant.DATE_FORMAT_DISPLAY, data.expiredDate
                )
            }

            if (data.subscribedDate.isNullOrEmpty() || TextUtils.equals(data.subscribedDate, "null")) {
                binding.viewSubscribeDate.visibility = View.GONE
            } else {
                binding.ctvDateSubscribe.text = SeatelUtils.getDateTime(
                    "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Constant.DATE_FORMAT_DISPLAY, data.subscribedDate
                )
            }

        } else {
            binding.viewRenewDate.visibility = View.VISIBLE
            binding.viewTopupBalanceNoCircle.visibility = View.INVISIBLE
            binding.layoutProgressBar.visibility = View.VISIBLE
            binding.viewExpiredDate.visibility = View.GONE
            binding.viewSubscribeDate.visibility = View.GONE

            if (data.renewDate.isNullOrEmpty() || TextUtils.equals(data.renewDate, "null")) {
                binding.ctvDateRenew.text = "N/A"
            } else {
                binding.ctvDateRenew.text = SeatelUtils.getDateTime(
                    "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Constant.DATE_FORMAT_DISPLAY, data.renewDate
                )
            }

            binding.viewProgressBar.dataLeftText = SeatelUtils.translatForDialog(
                context, context.getString(R.string.remaining_balance)
            )
            binding.viewProgressBar.max = data.totalBalance!!.toFloat()
            binding.viewProgressBar.isShowDollar = true
            binding.viewProgressBar.textSize = 80f

            val remainProgress = data.remainingBalance!!.toFloat()
            var duration: Long = 1500
            if (remainProgress == binding.viewProgressBar.max) {
                duration = 800
            }

            val finalDuration = duration
            val finalRemainProgress = remainProgress
            val delay = Handler()
            delay.postDelayed(object : Runnable {
                override fun run() {
                    val progressAnimator = ObjectAnimator.ofFloat(
                        binding.viewProgressBar, "progress", 0f, finalRemainProgress
                    )
                    progressAnimator.duration = finalDuration
                    progressAnimator.interpolator = DecelerateInterpolator()
                    progressAnimator.start()
                    delay.removeCallbacks(this)
                }
            }, 1000)
        }
    }
}
