package com.seatel.mobilehall.ui.yes_member.presenter

import android.content.Context
import com.android.volley.Request
import com.google.gson.Gson
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.yes_member.interactor.RewardHistoryInteractor
import com.seatel.mobilehall.ui.yes_member.model.RewardHistoryModel
import org.json.JSONObject

class RewardHistoryPresenter(
    private var mContext: Context,
    private var rewardHistoryInteractor: RewardHistoryInteractor.View
) : RewardHistoryInteractor.Presenter {


    override fun getRewardHistory(phoneNumber: String) {

        getRewardHistoryRequest(phoneNumber).setOnErrorListener {
            rewardHistoryInteractor.responseRewardHistoryFail(it)
        }.setOnResponseListener { response ->
            rewardHistoryInteractor.responseRewardHistorySucceed(getRewardHistoryList(response as JSONObject)!!)
        }.execute()
    }


    private fun getRewardHistoryList(response: JSONObject): RewardHistoryModel? {
        val gson = Gson()
        val data = gson.fromJson(response.toString(), RewardHistoryModel::class.java)

        return data
    }

    private fun getRewardHistoryRequest(phoneNumber: String): SeatelJSONObjectRequest {

        return object : SeatelJSONObjectRequest(mContext) {
            override fun getMethod(): Int {
                return Request.Method.GET
            }

            override fun getFunctionName(): String {
                return "yes-member/redeem-reward-history?phoneNumber=$phoneNumber"
            }
        }
    }

}


