package com.seatel.mobilehall.ui.profile.activity

import ProductServicesAdapter
import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.android.volley.NoConnectionError
import com.android.volley.TimeoutError
import com.android.volley.VolleyError
import com.google.gson.Gson
import com.seatel.mobilehall.BuildConfig
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.prefs.SeatelSharePreferences
import com.seatel.mobilehall.databinding.ActivityGetMoreDataBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.activity.InternationalCallDetailActivity
import com.seatel.mobilehall.ui.home.activity.LoyKobActivity
import com.seatel.mobilehall.ui.home.activity.OnePlanDetailActivity
import com.seatel.mobilehall.ui.home.interactor.AppProductsInteractor
import com.seatel.mobilehall.ui.home.model.AppProductsResponseModel
import com.seatel.mobilehall.ui.home.model.MainDataModel
import com.seatel.mobilehall.ui.home.presenter.AppProductsPresenter
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.customview.ErrorHandleView

class GetMoreDataActivity : BaseActivity<ActivityGetMoreDataBinding>(), AppProductsInteractor.View {

    private val productService: ArrayList<AppProductsResponseModel> = ArrayList()
    private var dataMainScreen: MainDataModel? = null
    private var mAppProductsPresenter: AppProductsPresenter? = null

    private var isOnlyDisplay = false
    private var layoutManager: RecyclerView.LayoutManager? = null
    var canSubscribe: Boolean = false

    override fun onGetAppProductsSucceed(appProductsList: ArrayList<AppProductsResponseModel>) {
        if (appProductsList.size == 0) {
            isOnlyDisplay = true
            productService.add(
                AppProductsResponseModel(
                    "internet-pack",
                    "Internet Pack",
                    "${BuildConfig.BASE_URL}uploads/internet-pack.png",
                    "5cd145dd4020a104f400d45b"
                )
            )
        } else {
            isOnlyDisplay = false
            productService.addAll(appProductsList)
        }
        setAdapterData()
        binding.errorView.visibility = View.GONE
    }

    override fun onGetAppProductsFailed(error: VolleyError) {
        isOnlyDisplay = false
        when (error) {
            is TimeoutError -> {
                binding.errorView.errorMessage = getString(R.string.connection_timeout)
                binding.errorView.setViewMode(ErrorHandleView.Mode.TIME_OUT)
            }

            is NoConnectionError -> {
                binding.errorView.errorMessage = getString(R.string.message_no_internet)
                binding.errorView.setViewMode(ErrorHandleView.Mode.NO_INTERNET)
            }

            else -> {
                binding.errorView.errorMessage = getString(R.string.no_data)
                binding.errorView.setViewMode(ErrorHandleView.Mode.NO_DATA)
            }
        }
    }

    private fun setAdapterData() {
        if (productService.size > 0) {
            for (i in 0 until productService.size) {
                canSubscribe = productService[i].canSubscribe!!

            }
        }

        binding.getmoredataRecyclerView.adapter = ProductServicesAdapter(this, productService) {
            when (it.code) {
                "one-plan" -> {
                    OnePlanDetailActivity.lunch(this)
                }

                "free-internet-promotion" -> {
                    /*  FreePromotionDetailActivity.lunch(
                          this,
                          getString(R.string.free_internet_promotion)
                      )*/
                }

                "international-call" -> {
                    binding.errorView.setViewMode(ErrorHandleView.Mode.LOADING)
                    InternationalCallDetailActivity.lunch(this)
                }

                "loy-kobs" -> LoyKobActivity.launch(
                    this,
                    it.canSubscribe!!,
                    it.code!!,
                    Constant.LoyKob
                )

                else -> {
                    LoyKobActivity.launch(this, it.canSubscribe!!, it.code!!, "Any")
                }
            }

        }
    }

    override fun getViewBinding(): ActivityGetMoreDataBinding {
        return ActivityGetMoreDataBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        activityEnterRightAnimation()
        setContentView(R.layout.activity_get_more_data)
        layoutManager = LinearLayoutManager(this)
        binding.getmoredataRecyclerView.layoutManager = layoutManager
        binding.errorView.setViewMode(ErrorHandleView.Mode.LOADING)
        mAppProductsPresenter = AppProductsPresenter(this, this)
        mAppProductsPresenter?.setTypeQuery("add-on")
        mAppProductsPresenter?.onGetAppProducts(getPhoneLogin())

        dataMainScreen = Gson().fromJson<MainDataModel>(
            SeatelSharePreferences.getInstance(this)?.getMainScreenData(),
            MainDataModel::class.java
        )
        if (dataMainScreen != null) {
            binding.ctvUserName.text = dataMainScreen!!.getCustName()
            binding.ctvPhoneNumber.text =
                SeatelUtils.phoneNumberFormat(dataMainScreen!!.getPhonNumber())
        }

    }


    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, GetMoreDataActivity::class.java)
            context.startActivity(intent)
        }
    }

    override fun onBackPressed() {
        super.onBackPressed()
        activityExitLeftAnimation()
    }

    override fun getToolbarTitle(): String {
        return resources.getString(R.string.get_more_data)
    }

}
