package com.seatel.mobilehall.ui.home.presenter

import android.content.Context
import com.android.volley.Request
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.home.interactor.ValuePackDetailInteractor
import com.seatel.mobilehall.ui.home.model.DataPackSecThreeModel
import com.seatel.mobilehall.ui.home.model.ValuePackSecTwoModel
import com.seatel.mobilehall.ui.home.model.ValuePackSectionModel
import com.seatel.mobilehall.ui.home.model.ValuePackTableModel
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.lang.LanguageManager
import org.json.JSONObject

class ValuePackDetailPresenter(private var mContext: Context) :
    ValuePackDetailInteractor.Presenter {

    private var mValuePackDataView: ValuePackDetailInteractor.View? = null

    private var lang: String? = "en"


    fun onDestroy() {
        mValuePackDataView = null
    }

    override fun onLoadValuePack() {
        mValuePackDataView = mContext as ValuePackDetailInteractor.View
        if (LanguageManager.getInstance(mContext).getLanguageCode() != null)
            lang = LanguageManager.getInstance(mContext).getLanguageCode()

        getValuePackDeatialRequest().setOnErrorListener { error ->
            //            mValuePackDataView?.onResponseFailed(error)
            mValuePackDataView?.onResponseValuePackSucceed(prepareTempSampleData())
        }.setOnResponseListener { response ->
            mValuePackDataView?.onResponseValuePackSucceed(prepareValuePackDetailModel(response as JSONObject))
        }.execute()
    }

    override fun onLoadFortunePack() {
        mValuePackDataView = mContext as ValuePackDetailInteractor.View
        if (LanguageManager.getInstance(mContext).getLanguageCode() != null)
            lang = LanguageManager.getInstance(mContext).getLanguageCode()

        getFortunePackDeatialRequest().setOnErrorListener { error ->
            //            mValuePackDataView?.onResponseFailed(error)
            mValuePackDataView?.onResponseValuePackSucceed(prepareTempSampleData())
        }.setOnResponseListener { response ->
            mValuePackDataView?.onResponseValuePackSucceed(prepareValuePackDetailModel(response as JSONObject))
        }.execute()
    }

    override fun onLoadSeatelAirlinePack() {
        mValuePackDataView = mContext as ValuePackDetailInteractor.View
        if (LanguageManager.getInstance(mContext).getLanguageCode() != null)
            lang = LanguageManager.getInstance(mContext).getLanguageCode()
        getSeatelAirlinePackDeatialRequest().setOnErrorListener { error ->
            mValuePackDataView?.onResponseValuePackSucceed(prepareTempSampleData())
        }.setOnResponseListener { response ->
            mValuePackDataView?.onResponseValuePackSucceed(prepareValuePackDetailModel(response as JSONObject))
        }.execute()
    }

    override fun onLoadLanmeiAirlinePack() {
        mValuePackDataView = mContext as ValuePackDetailInteractor.View
        if (LanguageManager.getInstance(mContext).getLanguageCode() != null)
            lang = LanguageManager.getInstance(mContext).getLanguageCode()
        getLanmeiAirlinelinePackDeatialRequest().setOnErrorListener { error ->
            mValuePackDataView?.onResponseValuePackSucceed(prepareTempSampleData())
        }.setOnResponseListener { response ->
            mValuePackDataView?.onResponseValuePackSucceed(prepareValuePackDetailModel(response as JSONObject))
        }.execute()
    }


    private fun prepareTempSampleData(): ValuePackSectionModel {
        val dataPackSection = ValuePackSectionModel()


//        val dataPackSectionOneModel = DataPackDetailSecOneModel()
//        dataPackSectionOneModel.mobileImageUrl = response.optJSONObject("section1").optString("mobileImageUrl")
//        dataPackSection.dataPackDetailSecOneModel = dataPackSectionOneModel

        val dataPackSecTwoModel = ValuePackSecTwoModel()
        dataPackSecTwoModel.title =
            "All-in-one pack that you will need as you go about your day. Subscribe to yes Value Pack $1 to get $350 balance for non-stop call, SMS and Internet data."
        dataPackSecTwoModel.subTitle =
            "The amount offered in each value pack can be used for on-net call, SMS and Internet, more than enough for your daily usage."
        dataPackSection.valuePackSecTwoModel = dataPackSecTwoModel

        var tableList = ArrayList<ValuePackTableModel>()

        val dataPackTableModel = ValuePackTableModel()
        dataPackTableModel.valuePrice = "1.0"
        dataPackTableModel.priceChange = "350.0"
        dataPackTableModel.validityDate = "7"
        tableList.add(dataPackTableModel)

        val dataPackTableModel2 = ValuePackTableModel()
        dataPackTableModel2.valuePrice = "2.0"
        dataPackTableModel2.priceChange = "550.0"
        dataPackTableModel2.validityDate = "10"
        tableList.add(dataPackTableModel2)

        val dataPackTableModel3 = ValuePackTableModel()
        dataPackTableModel3.valuePrice = "5.0"
        dataPackTableModel3.priceChange = "2000.0"
        dataPackTableModel3.validityDate = "30"
        tableList.add(dataPackTableModel3)

        val dataPackTableModel4 = ValuePackTableModel()
        dataPackTableModel4.valuePrice = "8.0"
        dataPackTableModel4.priceChange = "5550.0"
        dataPackTableModel4.validityDate = "30"
        tableList.add(dataPackTableModel4)

        dataPackSecTwoModel.table = tableList

        dataPackSection.valuePackSecTwoModel = dataPackSecTwoModel

        val dataPackThreeModel = DataPackSecThreeModel()
        dataPackThreeModel.description = "description"
        dataPackSection.valuePackSecThreeModel = dataPackThreeModel

        return dataPackSection
    }

    private fun prepareValuePackDetailModel(response: JSONObject): ValuePackSectionModel {

        val dataPackSection = ValuePackSectionModel()
        dataPackSection.type = response.optString("type")
//        val dataPackSectionOneModel = DataPackDetailSecOneModel()
//        dataPackSectionOneModel.mobileImageUrl = response.optJSONObject("section1").optString("mobileImageUrl")
//        dataPackSection.dataPackDetailSecOneModel = dataPackSectionOneModel

        val dataPackSecTwoModel = ValuePackSecTwoModel()
        dataPackSecTwoModel.title = response.optJSONObject("section2").optString("title")
        dataPackSecTwoModel.subTitle = response.optJSONObject("section2").optString("subTitle")
        dataPackSection.valuePackSecTwoModel = dataPackSecTwoModel

        val table = response.optJSONObject("section2").optJSONArray("table")
        var tableList = ArrayList<ValuePackTableModel>()
        for (i in 0 until table.length()) {

            val dataPackTableModel = ValuePackTableModel()

            val data = table.optJSONObject(i).optJSONArray("data")
            val fee = table.optJSONObject(i).optJSONArray("fee")
            val validate = table.optJSONObject(i).optJSONArray("validity")
            val activation = table.optJSONObject(i).optJSONArray("activation")

            dataPackTableModel.valuePrice = fee.optString(0)
            dataPackTableModel.priceChange = data.optString(0)
            dataPackTableModel.validityDate = validate.optString(0)
            dataPackTableModel.activation = activation.optString(0)

            tableList.add(dataPackTableModel)
        }

        dataPackSecTwoModel.table = tableList

        dataPackSection.valuePackSecTwoModel = dataPackSecTwoModel

        val dataPackThreeModel = DataPackSecThreeModel()
        dataPackThreeModel.description = response.optJSONObject("section3").optString("description")
        dataPackSection.valuePackSecThreeModel = dataPackThreeModel

        return dataPackSection
    }

    private fun getValuePackDeatialRequest(): SeatelJSONObjectRequest {

        return object : SeatelJSONObjectRequest(mContext) {

            override fun getFunctionName(): String {
                return "${Constant.VALUE_PACK}?lang=$lang"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }


        }
    }

    private fun getFortunePackDeatialRequest(): SeatelJSONObjectRequest {

        return object : SeatelJSONObjectRequest(mContext) {

            override fun getFunctionName(): String {
                return "${Constant.FORTUNE_PACK}?lang=$lang"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }

        }
    }

    private fun getSeatelAirlinePackDeatialRequest(): SeatelJSONObjectRequest {

        return object : SeatelJSONObjectRequest(mContext) {

            override fun getFunctionName(): String {
                return "${Constant.SEATELAIRLINE_PACK}?lang=$lang"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }

        }
    }

    private fun getLanmeiAirlinelinePackDeatialRequest(): SeatelJSONObjectRequest {

        return object : SeatelJSONObjectRequest(mContext) {

            override fun getFunctionName(): String {
                return "${Constant.LANMEIAIRLINE_PACK}?lang=$lang"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }

        }
    }
}


