package com.seatel.mobilehall.ui.home.model

import com.seatel.mobilehall.util.manager.PlanSubscriptionRequestModel

/**
 *
 *
 * @author Noel
 * @version
 * @created on 19-Oct-18
 */
class CartRequestModel<T : CartRequestModel.Item>() {
    var phoneNumber: String? = ""
    var items: List<T>? = null
    var dynamicCardPrice: Boolean = true

    constructor(phoneNumber: String? = "",dynamicCardPrice: Boolean = true,
                items: List<T>? = null) : this() {
        this.phoneNumber = phoneNumber
        this.dynamicCardPrice = dynamicCardPrice
        this.items = items
    }

    open class Item {
        var type: String? = ""
        var quantity: Int? = 1
    }

    data class SimCard(var planSubscription: PlanSubscriptionRequestModel<PlanSubscriptionRequestModel.AddOns>? = null,
                       var topUpAmount: Int? = null,
                       var simCardNumber: String? = "") : Item() {
        init {
            type = "sim-card"
        }
    }

//    data class SimCard(var planCode: String? = Constant.MySubscription.ONE_SUB_PLAN_CODE,
//                       var topUpAmount: Int? = null,
//                       var simCardNumber: String? = "") : Item() {
//        init {
//            type = "sim-card"
//        }
//    }

    class Device() : Item() {
        init {
            type = "device"
        }

        var deviceUrl: String? = ""
        var colorId: String? = ""
        var storage: Int? = null

        constructor(deviceUrl: String?, color: String?, storage: Int?) : this() {
            this.deviceUrl = deviceUrl
            this.colorId = color
            this.storage = storage
        }


    }

    class Scratch() : Item() {
        init {
            type = "scratch-card"
        }

        var scratchCardAmount: Double? = null

        constructor(scratchCardAmount: Double?) : this() {
            this.scratchCardAmount = scratchCardAmount
        }
    }
}