package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.home.model.DataPlansOrderModel
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils

open class MyOrderSimCardAdapter(
    private val mContext: Context,
    private val myCartModels: ArrayList<DataPlansOrderModel>
) :
    RecyclerView.Adapter<MyOrderSimCardAdapter.ViewHolderDevice>() {

    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): MyOrderSimCardAdapter.ViewHolderDevice {
        return ViewHolderDevice(
            LayoutInflater.from(mContext).inflate(R.layout.item_my_order_sim_card, parent, false)
        )
    }

    override fun onBindViewHolder(holder: MyOrderSimCardAdapter.ViewHolderDevice, position: Int) {
        holder.bind(mContext, myCartModels[position])
    }

    override fun getItemCount(): Int {
        return myCartModels.size
    }

    class ViewHolderDevice(itemView: View) : RecyclerView.ViewHolder(itemView) {
        private val orderRowName: TextView = itemView.findViewById(R.id.text_view_cart_name)
        private val orderRowNameCenter: TextView =
            itemView.findViewById(R.id.text_view_order_name_center_row)
        private val orderDes: TextView = itemView.findViewById(R.id.text_view_order_name)
        private val orderPrice: TextView = itemView.findViewById(R.id.text_view_order_price)
        private val imgResource: ImageView = itemView.findViewById(R.id.img_order)
        var dayStr = SeatelUtils.translatForDialog(itemView.context, "Day")

        fun bind(context: Context, myCartModel: DataPlansOrderModel) {
            orderRowName.visibility = View.VISIBLE
            orderDes.visibility = View.VISIBLE
            orderRowNameCenter.visibility = View.GONE
            orderRowName.text = SeatelUtils.toCamelCase(myCartModel.planName)

            if (myCartModel.isAddOn) {
                var str = "${
                    SeatelUtils.translatForDialog(
                        context,
                        myCartModel.planDescription
                    )
                } (${checkDayStr(dayStr, myCartModel.duration!!)} = ${
                    SeatelUtils.setFormatcurrency(
                        myCartModel.planPrice
                    )
                })"
                if (myCartModel.planDescription?.toLowerCase() == "value pack")
                    str = "${
                        SeatelUtils.translatForDialog(
                            context,
                            myCartModel.planDescription
                        )
                    } (${
                        SeatelUtils.formatDecimalNumber(
                            myCartModel.planPrice!!,
                            "$#.#"
                        )
                    } = ${
                        SeatelUtils.formatDecimalNumber(
                            myCartModel.duration!!.toDouble(),
                            "$###,###"
                        )
                    })"
                orderDes.text = str
                orderPrice.text = ""
            } else {
                orderDes.text = myCartModel.planDescription
                orderPrice.text = "${SeatelUtils.setFormatcurrency(myCartModel.planPrice)}"
            }
            Glide.with(context).load(myCartModel.planIcon).into(imgResource)
            if (TextUtils.equals(
                    myCartModel.planName?.toLowerCase(),
                    context.getString(R.string.sim_price).toLowerCase()
                )
            ) {
                orderRowName.visibility = View.INVISIBLE
                orderDes.visibility = View.INVISIBLE
                orderRowNameCenter.visibility = View.VISIBLE
                orderRowNameCenter.text = SeatelUtils.toCamelCase(myCartModel.planName)
//                Glide.with(context).load(R.drawable.ic_sim_price).into(imgResource)
            }
        }

        private fun checkDayStr(strDay: String, dayCount: Int): String {
            return when (SeatelUtils.getLangaugeCode(itemView.context)) {
                Constant.KHMER, Constant.CHINESE -> {
                    "$dayCount$strDay"
                }
                else -> {
                    "$dayCount-$strDay"
                }
            }
        }

    }
}
