package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.databinding.ItemEshopBinding
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.activity.EShopPhaseTwoActivity

class EshopPhaseTwoAdapter(
    private val mContext: Context,
    private val eShopModels: ArrayList<MenuDataEshop>,
    private val itemEshop: (EShopPhaseTwoActivity.ItemEshop) -> Unit
) : BaseAdapter<EshopPhaseTwoAdapter.EShopViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): EShopViewHolder {
        // Use View Binding instead of LayoutInflater.inflate
        val binding = ItemEshopBinding.inflate(LayoutInflater.from(mContext), parent, false)
        return EShopViewHolder(binding)
    }

    override fun onBindViewHolder(holder: EShopViewHolder, position: Int) {
        // Make sure the item view is hidden initially
        holder.itemView.visibility = View.INVISIBLE
        setAnimations(holder.itemView, position)
        holder.bindView(mContext, eShopModels[position], position, eShopModels.size, itemEshop)
    }

    override fun getItemCount(): Int {
        return eShopModels.size
    }

    // ViewHolder using View Binding
    class EShopViewHolder(private val binding: ItemEshopBinding) : RecyclerView.ViewHolder(binding.root) {

        fun bindView(
            context: Context,
            rowData: MenuDataEshop,
            position: Int,
            totalRow: Int,
            rowListener: (EShopPhaseTwoActivity.ItemEshop) -> Unit
        ) {
            // Bind data using View Binding
            binding.textEshopName.text = rowData.title
            binding.imgEshop.setImageResource(rowData.imgNameRow)

            // Tag is set on the layout_eshop, as in your original code
            binding.layoutEshop.tag = rowData.Type

            // Set the click listener using View Binding
            binding.layoutEshop.setOnClickListener {
                rowListener(it.tag as EShopPhaseTwoActivity.ItemEshop)
            }
        }
    }

    data class MenuDataEshop(
        val title: String = "",
        val imgNameRow: Int,
        val Type: EShopPhaseTwoActivity.ItemEshop,
        val messageGuideApp: String = ""
    )
}
