package com.seatel.mobilehall.ui.home.activity

import android.app.Notification
import android.app.NotificationChannel
import android.app.NotificationManager
import android.content.Context
import android.content.Intent
import android.os.Build
import android.os.Bundle
import android.view.View
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout
import com.android.volley.NoConnectionError
import com.android.volley.TimeoutError
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ActivityNotificationListBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.adapter.NotificationAdapter
import com.seatel.mobilehall.ui.home.interactor.NotificationListInteractor
import com.seatel.mobilehall.ui.home.model.NotificationModel
import com.seatel.mobilehall.ui.home.presenter.NotificationListPresenter
import com.seatel.mobilehall.util.customview.ErrorHandleView

class NotificationListActivity : BaseActivity<ActivityNotificationListBinding>(),
    NotificationListInteractor.View,
    SwipeRefreshLayout.OnRefreshListener {

    private lateinit var notificationPresenter: NotificationListPresenter
    private lateinit var notificationManager: NotificationManager
    private lateinit var notificationChannel: NotificationChannel
    lateinit var builder: Notification.Builder
    private var channelID = "com.seatel.mobilehall.view.activity"

    private var linearLayoutManager: LinearLayoutManager? = null
    private var mOffset = 0
    private val LIMIT_OFFSET = 10
    private var notificationAdapter: NotificationAdapter? = null
    private var isFistRequest = false
    override fun getViewBinding(): ActivityNotificationListBinding {
        return ActivityNotificationListBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        // setContentView(R.layout.activity_notification_list)
        activityEnterUpAnimation()
        init()
    }

    private fun getMyNotificaitonList() {
        isFistRequest = true
        notificationAdapter?.clearData()
        mOffset = 0
        binding.errorView.setViewMode(ErrorHandleView.Mode.LOADING)
        notificationPresenter.onLoadData(getPhoneLogin(), mOffset)
    }

    override fun onLoadMore() {
        mOffset += LIMIT_OFFSET
//        binding.errorView.setViewMode(ErrorHandleView.Mode.LOADING)
        notificationPresenter.onLoadData(getPhoneLogin(), mOffset)
    }

    override fun responseSucceed(notificationList: ArrayList<NotificationModel>) {
        hideProgress()
        binding.swipeRefreshLayout.isRefreshing = false
        if (notificationList.size == 0 && mOffset == 0) {
            binding.errorView.errorMessage = getString(R.string.no_notification)
            binding.errorView.setViewMode(ErrorHandleView.Mode.NO_DATA)
        } else {
            //   setNotification(notificationList[0].title, notificationList[0].message)
            notificationAdapter?.addItems(notificationList)
            binding.errorView.visibility = View.GONE
        }
    }


    override fun onRefresh() {
        getMyNotificaitonList()
    }

    override fun responseFail(error: VolleyError) {
        hideProgress()
        when (error) {
            is TimeoutError -> {
                binding.errorView.errorMessage = getString(R.string.connection_timeout)
                binding.errorView.setViewMode(ErrorHandleView.Mode.TIME_OUT)
            }

            is NoConnectionError -> {
                binding.errorView.errorMessage = getString(R.string.message_no_internet)
                binding.errorView.setViewMode(ErrorHandleView.Mode.NO_INTERNET)
            }

            else -> {
                if (mOffset == 0) {
                    binding.errorView.errorMessage = getString(R.string.no_notification)
                    binding.errorView.setViewMode(ErrorHandleView.Mode.NO_NOTIFICATION)
                }
            }
        }
        binding.swipeRefreshLayout.isRefreshing = false
    }

    private fun init() {
        showProgress()
        notificationAdapter = NotificationAdapter(ArrayList(), this, this)
        binding.recyclerViewNotification.adapter = notificationAdapter
        linearLayoutManager = LinearLayoutManager(this)
        binding.recyclerViewNotification.layoutManager = linearLayoutManager

        notificationPresenter = NotificationListPresenter(this)
        getMyNotificaitonList()
        binding.swipeRefreshLayout.setOnRefreshListener(this)
        binding.swipeRefreshLayout.setColorSchemeColors(
            ContextCompat.getColor(
                this,
                R.color.colorPrimary
            )
        )

        binding.recyclerViewNotification.addOnScrollListener(object :
            RecyclerView.OnScrollListener() {
            override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
                super.onScrolled(recyclerView, dx, dy)
                if (!isFistRequest)
                    notificationAdapter?.onScrollEvent(linearLayoutManager!!)
                isFistRequest = false
            }
        })
    }

    private fun setNotification(title: String, contentTitle: String) {
        notificationManager = getSystemService(Context.NOTIFICATION_SERVICE) as NotificationManager
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            notificationChannel =
                NotificationChannel(channelID, "i am testing", NotificationManager.IMPORTANCE_HIGH)
            notificationChannel.enableLights(true)
            notificationChannel.lightColor = getColor(R.color.colorPrimary)
            notificationChannel.enableVibration(true)
            notificationManager.createNotificationChannel(notificationChannel)

            builder = Notification.Builder(this, channelID)
                .setContentTitle(title)
                .setContentText(contentTitle)
                .setSmallIcon(R.mipmap.ic_launcher)

            notificationManager.notify(111, builder.build())
        }
    }


    override fun isDisplayHome(): Boolean {
        return true
    }

    override fun isShowBackButtonLeft(): Boolean {
        return true
    }

    override fun getToolbarTitle(): String {
        return getString(R.string.notification)
    }

    override fun isCancelBackType(): Boolean {
        return true
    }

    override fun onBackPressed() {
        super.onBackPressed()
        activityExitDownAnimation()
    }

    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, NotificationListActivity::class.java)
            context.startActivity(intent)
        }
    }
}
