package com.seatel.mobilehall.util.customview

import android.content.Context
import android.graphics.Canvas
import android.util.AttributeSet
import android.widget.EditText

class PrefixEditText : EditText {

    internal var mOriginalLeftPadding = -1f

    constructor(context: Context) : super(context) {
        calculatePrefix()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        calculatePrefix()
    }

//    constructor(context: Context, attrs: AttributeSet,
//                defStyleAttr: Int) : super(context, attrs, defStyleAttr) {
//        calculatePrefix()
//    }

    private fun calculatePrefix() {
        if (mOriginalLeftPadding == -1f) {
            val prefix = "$ "
            val widths = FloatArray(prefix.length)
            paint.getTextWidths(prefix, widths)
            var textWidth = 0f
            for (w in widths) {
                textWidth += w
            }
            mOriginalLeftPadding = compoundPaddingLeft.toFloat()
            setPadding((textWidth + mOriginalLeftPadding).toInt(),
                    0, 0,
                    0)
        }
    }

    override fun onDraw(canvas: Canvas) {
        super.onDraw(canvas)
        val prefix = "$ "
        canvas.drawText(prefix, mOriginalLeftPadding,
                getLineBounds(0, null).toFloat(), paint)
    }
}