package com.seatel.mobilehall.ui.yes_member.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import coil.load
import com.android.volley.VolleyError
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivityCoinBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.yes_member.adapter.RewardAdapter
import com.seatel.mobilehall.ui.yes_member.interactor.RewardInteractor
import com.seatel.mobilehall.ui.yes_member.model.RewardModel
import com.seatel.mobilehall.ui.yes_member.presenter.RewardPresenter
import com.seatel.mobilehall.util.SeatelAlertDialog

class CoinActivity : BaseActivity<ActivityCoinBinding>(), RewardInteractor.View {


    companion object {
        fun launch(context: Context, imgCoin: String, coinEarn: String, coinDescription: String) {
            val intent = Intent(context, CoinActivity::class.java)
            intent.putExtra("img_coin", imgCoin)
            intent.putExtra("coin_earn", coinEarn)
            intent.putExtra("coin_description", coinDescription)
            context.startActivity(intent)
        }
    }

    override fun getViewBinding(): ActivityCoinBinding {
        return ActivityCoinBinding.inflate(layoutInflater)
    }

    private val TAG = "CoinActivity"


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        activityEnterRightAnimation()
        init()
    }

    private fun init() {

        binding.ivBack.setOnClickListener {
            onBackPressed()
        }

        binding.tvCoinEarn.text = "Your coins " + intent.getStringExtra("coin_earn")
        binding.tvCoinDescription.text = intent.getStringExtra("coin_description")
        binding.ivCoinBanner.load(intent.getStringExtra("img_coin")) {
            crossfade(true)
        }

        RewardPresenter(this, this).getReward(getPhoneLogin())

        binding.btnHowEarnCoin.setOnClickListener {
            EarnCoinActivity.launch(this)
        }

        binding.btnEarnCoinHistory.setOnClickListener {
            EarnCoinHistoryActivity.launch(this)
        }

        binding.btnRewardHistory.setOnClickListener {
            RewardHistoryActivity.launch(this)
        }
    }

    override fun responseRewardSucceed(rewardList: ArrayList<RewardModel>) {
        val adapter = RewardAdapter(this, rewardList)
        binding.recylerReward.adapter = adapter

    }

    override fun responseRewardFail(error: VolleyError) {
        SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(error))
            .show()
    }


    override fun isDisplayToolbar(): Boolean {
        return false
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
    }

}