package com.seatel.mobilehall.ui.packages.presenter

import android.content.Context
import com.android.volley.Request
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.packages.interactor.SwitchPlanInteractor
import org.json.JSONObject

class SwitchPlanPresenter(
    private var context: Context,
    private var switchPlanInteractor: SwitchPlanInteractor.View
) : SwitchPlanInteractor.presenter {

    override fun SwitchPlan(phoneNumber: String, newPlanCode: String) {
        switchPlanRequest(phoneNumber,newPlanCode).setOnErrorListener { error ->
            switchPlanInteractor.onSwitchPlanFailed (error)

        }.setOnResponseListener { response ->
            switchPlanInteractor.onSwitchPlanSucceed(response as JSONObject)
        }.execute()
    }




    private fun switchPlanRequest(phoneNumber: String,newPlanCode: String): SeatelJSONObjectRequest {
        return object : SeatelJSONObjectRequest(context){
            override fun getFunctionName(): String {
                return ""
            }

            override fun onGetBodyRequest(): String {
                val obj = JSONObject()
                obj.put("phoneNumber", phoneNumber)
                obj.put("newPlanCode", newPlanCode)

                return obj.toString()
            }

            override fun getMethod(): Int {
                return Request.Method.POST
            }

        }
    }

}