package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.os.Build
import android.text.Html
import android.text.method.LinkMovementMethod
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R


/**
 * Created by mac on 8/27/2018 AD.
 */
class TermAndServiceFooterAdapter(
    private val mContext: Context,
    private var mTermAndServiceList: List<String>,
    private val mIsHTMLStyle: Boolean
) : RecyclerView.Adapter<TermAndServiceFooterAdapter.ViewHolder?>() {


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val view: View = LayoutInflater.from(mContext)
            .inflate(R.layout.item_terms_and_service_footer, parent, false)
        return ViewHolder(view)
    }

    fun resetDataNew(termAndServiceList: List<String>) {
        mTermAndServiceList = termAndServiceList
        notifyDataSetChanged()
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.onBind(mTermAndServiceList[position])
    }

    override fun getItemCount(): Int {
        return mTermAndServiceList.size
    }

    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        private val customTextView: TextView = itemView as TextView
        fun onBind(text: String) {
            if (mIsHTMLStyle) {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                    customTextView.text = Html.fromHtml(text, Html.FROM_HTML_MODE_COMPACT)
                    customTextView.movementMethod = LinkMovementMethod.getInstance()
                } else {
                    customTextView.text = Html.fromHtml(text)
                    customTextView.movementMethod = LinkMovementMethod.getInstance()
                }
            } else customTextView.setText(text)
        }

    }
}