package com.seatel.mobilehall.util;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.widget.FrameLayout;

import androidx.camera.view.PreviewView;

import com.seatel.mobilehall.R;

public class RoundedPreviewView extends FrameLayout {

    private PreviewView innerPreviewView;

    public RoundedPreviewView(Context context) {
        super(context);
        init(context);
    }

    public RoundedPreviewView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public RoundedPreviewView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private void init(Context context) {
        LayoutInflater.from(context).inflate(R.layout.rounded_preview_view, this, true);
        innerPreviewView = findViewById(R.id.innerPreviewView);
    }

    public PreviewView getPreviewView() {
        return innerPreviewView;
    }
}