package com.seatel.mobilehall.ui.yes_member.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.KeyEvent
import android.view.inputmethod.EditorInfo
import android.widget.EditText
import com.android.volley.VolleyError
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivityPartnerSearchCategoryBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.yes_member.adapter.PartnerSearchCategoryListAdapter
import com.seatel.mobilehall.ui.yes_member.interactor.PartnerCategoryInteractor
import com.seatel.mobilehall.ui.yes_member.model.PartnerSearchCategoryModel
import com.seatel.mobilehall.ui.yes_member.presenter.PartnerCategoryPresenter
import com.seatel.mobilehall.util.SeatelAlertDialog

class PartnerSearchCategoryActivity : BaseActivity<ActivityPartnerSearchCategoryBinding>(),
    PartnerCategoryInteractor.View {

    private lateinit var originalList: ArrayList<PartnerSearchCategoryModel>
    private lateinit var adapter: PartnerSearchCategoryListAdapter

    companion object {
        fun launch(context: Context, category: String) {
            val intent = Intent(context, PartnerSearchCategoryActivity::class.java)
            intent.putExtra("category", category)
            context.startActivity(intent)
        }
    }

    override fun getViewBinding(): ActivityPartnerSearchCategoryBinding {
        return ActivityPartnerSearchCategoryBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        super.activityEnterRightAnimation()
        PartnerCategoryPresenter(this, this).onPartnerCategory(intent.getStringExtra("category")!!)
        setupSearch(binding.btnSearch)
        binding.ivBack.setOnClickListener {
            onBackPressed()
        }

    }

    private fun setupSearch(searchEditText: EditText) {
        searchEditText.setOnEditorActionListener { _, actionId, event ->
            if (actionId == EditorInfo.IME_ACTION_SEARCH ||
                (event != null && event.keyCode == KeyEvent.KEYCODE_ENTER && event.action == KeyEvent.ACTION_DOWN)
            ) {

                filterList(searchEditText.text.toString())
                return@setOnEditorActionListener true
            }
            false
        }
    }

    private fun filterList(query: String) {
        val filteredList = originalList.filter {
            it.name.contains(
                query,
                ignoreCase = true
            ) // Assuming PartnerSearchCategoryModel has a `name` field
        }
        adapter.updateList(ArrayList(filteredList)) // Update the adapter with the filtered data
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
    }


    override fun isDisplayToolbar(): Boolean {
        return false
    }

    override fun responsePartnerCategorySucceed(topPartnerList: ArrayList<PartnerSearchCategoryModel>) {
        originalList = topPartnerList
        adapter = PartnerSearchCategoryListAdapter(this, originalList)
        binding.recyclerPartner.adapter = adapter
    }

    override fun responsePartnerCategoryFail(error: VolleyError) {
        SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(error))
            .show()
    }
}