package com.seatel.mobilehall.ui.packages.adapter

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import coil.load
import com.seatel.mobilehall.databinding.LayoutRikReayBinding
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.packages.model.RikReayModel

class RikReayAdapter(private var rikReayModel: RikReayModel) :
    BaseAdapter<RikReayAdapter.ViewHolder>() {

    class ViewHolder(var binding: LayoutRikReayBinding) : RecyclerView.ViewHolder(binding.root)

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val binding = LayoutRikReayBinding.inflate(
            LayoutInflater.from(parent.context), parent, false
        )
        return ViewHolder(binding)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val context = holder.binding.root.context

        // Load images using Coil
        holder.binding.ivHeaderBanner.load(rikReayModel.backgroundImg) {
            crossfade(true)
        }

        // Set text for header
        holder.binding.tvHeaderTitle.text = rikReayModel.mainTitle
        holder.binding.tvHeaderSubTitle.text = rikReayModel.mainContent[0].title

        // Set content in WebView
        holder.binding.tvHeaderDescription.apply {
            settings.javaScriptEnabled = true
            loadDataWithBaseURL(null, rikReayModel.mainContent[0].content, "text/html", "UTF-8", null)
            settings.defaultFontSize = 12
        }

        // Set sub-header image using Coil
        holder.binding.ivSubHeader.load(rikReayModel.mainContent[1].imgurl) {
            crossfade(true)
        }

        // Set sub-header content in WebView
        holder.binding.tvSubHeaderSubTitle.apply {
            settings.javaScriptEnabled = true
            loadDataWithBaseURL(null, rikReayModel.mainContent[1].content, "text/html", "UTF-8", null)
            settings.defaultFontSize = 12
        }

        // Set content title and WebView for third section
        holder.binding.tvContentTitle.text = rikReayModel.mainContent[2].title
        holder.binding.mWebView.apply {
            settings.javaScriptEnabled = true
            loadDataWithBaseURL(null, rikReayModel.mainContent[2].content, "text/html", "UTF-8", null)
            settings.defaultFontSize = 12
        }

        // Set table title
        holder.binding.tvTableTitle.text = rikReayModel.mainContent[2].tableTitle

        // Set the RecyclerView adapter for the table section
        holder.binding.mRecyclerTable.adapter = RikReakDetailAdapter(context, rikReayModel)

        // Set last title
        holder.binding.lastTitle.text = rikReayModel.mainContent[3].title

        // Set last sub-title in WebView
        holder.binding.lastSubTitle.apply {
            settings.javaScriptEnabled = true
            loadDataWithBaseURL(null, rikReayModel.mainContent[3].content, "text/html", "UTF-8", null)
            settings.defaultFontSize = 12
        }
    }

    override fun getItemCount(): Int {
        return 1
    }

    override fun getItemViewType(position: Int): Int {
        return position
    }
}
