package com.seatel.mobilehall.ui.yes_member.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import coil.load
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.yes_member.model.TopPartnerModelItem

class YesMemberAdapter(
    private var mContext: Context, private var yesPartnerModelItem: ArrayList<TopPartnerModelItem>
) : BaseAdapter<YesMemberAdapter.ViewHolder>() {

    class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val logo = itemView.findViewById<ImageView>(R.id.iv_partner_logo)
        val title = itemView.findViewById<TextView>(R.id.tv_partner_title)
        val image = itemView.findViewById<ImageView>(R.id.iv_image)
        val discount = itemView.findViewById<TextView>(R.id.tv_discount)
        val discountBg = itemView.findViewById<ImageView>(R.id.iv_discount_bg)
    }

    override fun onCreateViewHolder(
        parent: ViewGroup, viewType: Int
    ): ViewHolder {
        return ViewHolder(
            LayoutInflater.from(mContext).inflate(R.layout.item_yes_member, parent, false)
        )
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        val data = yesPartnerModelItem[position]

        holder.logo.load(data.icon)
        holder.title.text = data.name
        holder.image.load(data.banner)

        if (data.discount > 0) {
            holder.discount.visibility = View.VISIBLE
            holder.discountBg.visibility = View.VISIBLE
        } else {
            holder.discount.visibility = View.GONE
            holder.discountBg.visibility = View.GONE
        }

        holder.discount.text = data.discountDesc
    }

    override fun getItemCount(): Int {
        return yesPartnerModelItem.size
    }
}