package com.seatel.mobilehall.ui.game

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.View
import com.android.volley.NoConnectionError
import com.android.volley.Request
import com.android.volley.TimeoutError
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.LayoutGameRewardBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.customview.ErrorHandleView
import com.seatel.mobilehall.util.dialogannouncement.CustomGameDialog
import org.json.JSONObject

class GameRewardActivity : BaseActivity<LayoutGameRewardBinding>(), GameInteractor.View {




    companion object {
        fun launch(context: Context) {
            val intent = Intent(context, GameRewardActivity::class.java)
            context.startActivity(intent)
        }
    }

    private var firstOpen = false
    override fun getViewBinding(): LayoutGameRewardBinding {
        return LayoutGameRewardBinding.inflate(layoutInflater)
    }


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(binding.root)
        binding.errorView.setViewMode(ErrorHandleView.Mode.LOADING)
        binding.imageViewBack.setOnClickListener {
            onBackPressed()
        }
        firstOpen = true
        GamePresenter(this, this).getGameReward("${getPhoneLogin()}")
    }

    override fun onGameRewardSucceed(angPaoListItem: ArrayList<GameModel>) {
        firstOpen = false
        binding.errorView.visibility = View.GONE
        binding.gameRecycler.apply {
            adapter = GameRewardAdapter(this@GameRewardActivity, angPaoListItem) {
                binding.errorView.visibility = View.VISIBLE
                claimPrize(it._id, it.usefor)
            }
        }


    }

    override fun onGameRewardFailed(error: VolleyError) {
        firstOpen = false
        binding.errorView.visibility = View.GONE
        when (error) {
            is TimeoutError -> {
                binding.errorView.errorMessage = getString(R.string.connection_timeout)
                binding.errorView.setViewMode(ErrorHandleView.Mode.TIME_OUT)
            }

            is NoConnectionError -> {
                binding.errorView.errorMessage = getString(R.string.message_no_internet)
                binding.errorView.setViewMode(ErrorHandleView.Mode.NO_INTERNET)
            }

            else -> {
                binding.errorView.errorMessage = getString(R.string.no_data)
                binding.errorView.setViewMode(ErrorHandleView.Mode.NO_DATA)
            }
        }

    }

    private fun claimPrize(id: String, type: String) {
        object : SeatelJSONObjectRequest(this) {
            override fun getFunctionName(): String {
                return "v2/seatel/claim-prize/$id/chaol-chhoung"
            }

            override fun getMethod(): Int {
                return Request.Method.PUT
            }

        }.setOnErrorListener {
            binding.errorView.visibility = View.GONE
            SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(it)).show()

        }.execute {
            binding.errorView.visibility = View.GONE
            val mTitle = (it as JSONObject).optString("smsTitle")
            val mPrize = it.optString("prize")
            val image = it.optString("image")
            val subtitle = it.optString("smsContent")
            val valentineDialog =
                CustomGameDialog(this, mTitle, mPrize, subtitle, image, true, true)
            valentineDialog.show()
            valentineDialog.setOnDismissListener {
                onResume()
            }


        }
    }


    override fun onResume() {
        super.onResume()
        if (!firstOpen)
            GamePresenter(this, this).getGameReward("${getPhoneLogin()}")
    }


}