package com.seatel.mobilehall.ui.login.presenter

import android.content.Context
import android.text.TextUtils
import com.android.volley.Request
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.data.prefs.SeatelSharePreferences
import com.seatel.mobilehall.ui.login.interactor.LoginInteractor
import com.seatel.mobilehall.util.Constant
import org.json.JSONException
import org.json.JSONObject
import java.util.*

class LoginPresenter(
    private var context: Context,
    private var mLoginView: LoginInteractor.View? = null
) : LoginInteractor.Presenter {

    private var requestUserWithPhone: SeatelJSONObjectRequest? = null
    private var requestUserWithUserId: SeatelJSONObjectRequest? = null

    fun onDestroy() {
        mLoginView = null
    }

    override fun onLoginWithSocial(userId: String) {

        getLoginWithRequest(userId).setOnErrorListener { error ->
            mLoginView?.onLoginFailed(error)
        }.setOnResponseListener { response ->
            var isNoneSeatel = false
            var isPostPaid = false
            val message = response as JSONObject

            var typeNone = ""
            if (message.has("type")) {
                typeNone = message.optString("type")
            }

            if (TextUtils.equals(typeNone.lowercase(Locale.getDefault()), "off-net"))
                isNoneSeatel = true
            else {
                if (TextUtils.equals(typeNone.lowercase(Locale.getDefault()), "postpaid")) {
                    isPostPaid = true
                }
            }

            if (message.optBoolean("status", false))
                mLoginView?.onAccountExist(
                    true,
                    message.optString("phoneNumber", ""),
                    isNoneSeatel,
                    isPostPaid
                )
            else
                mLoginView?.onAccountExist(
                    false,
                    message.optString("message", ""),
                    isNoneSeatel,
                    isPostPaid
                )
        }.execute()
    }

    override fun onLogin(phoneNum: String, pass: String) {

        getLoginRequest(phoneNum, pass).setOnErrorListener { error ->
            mLoginView?.onLoginFailed(error)
        }.setOnResponseListener {

            var isNoneSeatel = false
            var isPostPaid = false
            if (it != null) {
                val data = it as JSONObject
                var typeNone = ""
                if (data.has("type")) {
                    typeNone = data.optString("type")
                }

                if (TextUtils.equals(typeNone, "off-net"))
                    isNoneSeatel = true
                else {
                    if (TextUtils.equals(typeNone.lowercase(Locale.getDefault()), "postpaid")) {
                        isPostPaid = true
                    }
                }
            }
            mLoginView?.onLoginSucceed(isNoneSeatel, isPostPaid)
        }.execute()
    }

    private fun getLoginRequest(phoneNum: String, pass: String): SeatelJSONObjectRequest {
        SeatelSharePreferences.getInstance(context)!!.setPasswordLogin(pass)

        requestUserWithPhone?.cancel()
        requestUserWithPhone = object : SeatelJSONObjectRequest(context) {


            override fun onGetBodyRequest(): String {
                val data = JSONObject()
                try {
                    data.put("phoneNumber", phoneNum)
                    data.put("password", pass)
                } catch (e: JSONException) {
                    e.printStackTrace()
                }

                return data.toString()
            }

            override fun getFunctionName(): String {
                return Constant.LOGIN
            }

            override fun getMethod(): Int {
                return Request.Method.POST
            }

            override fun getBaseController(): String {
                return ""
            }

        }
        return requestUserWithPhone!!
    }

    private fun getLoginWithRequest(userId: String): SeatelJSONObjectRequest {

        requestUserWithUserId?.cancel()
        requestUserWithUserId = object : SeatelJSONObjectRequest(context) {

            override fun getFunctionName(): String {
                return "seatel/verify-socialId"
            }

            override fun getMethod(): Int {
                return Request.Method.POST
            }

            override fun onGetBodyRequest(): String {
                val data = JSONObject()
                try {
                    data.put("socialId", userId)
                    // data.put("socialType", socialType)
                } catch (e: JSONException) {
                    e.printStackTrace()
                }

                return data.toString()
            }
        }
        return requestUserWithUserId!!
    }
}