package com.seatel.mobilehall.ui.home.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.seatel.mobilehall.R;
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter;
import com.seatel.mobilehall.ui.packages.model.TableModel;
import com.seatel.mobilehall.ui.packages.model.TableSubModel;

import java.util.ArrayList;
import java.util.List;

public class
InternationalCallAdapter extends BaseAdapter<RecyclerView.ViewHolder> {

    private final Context mContext;
    private final List<TableModel> mTableModel;
    //    private List<InternationalCallDetailActivity.TableModel> mTableModelDislay;
    private final int VIEW_TYPE_TITLE = 0;
    private final int VIEW_TYPE_SUBTITLE = 1;
//    private List<InternationalCallDetailActivity.TableSubModel> mTableSubModel;

    public InternationalCallAdapter(Context mContext, List<TableModel> tableModel) {
        this.mContext = mContext;
        this.mTableModel = tableModel;
//        this.mTableModelDislay = tableModel;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (VIEW_TYPE_TITLE == viewType)
            return new TitleViewHolder(LayoutInflater.from(mContext).inflate(R.layout.item_table_header_internationalcall, parent, false));
        else
            return new DetailViewHolder(LayoutInflater.from(mContext).inflate(R.layout.item_international_call, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
//        holder.itemView.setVisibility(View.INVISIBLE);
//        setAnimation(holder.itemView, position);

        if (holder instanceof TitleViewHolder)
            ((TitleViewHolder) holder).onBind();
        else if (holder instanceof DetailViewHolder)
            ((DetailViewHolder) holder).onBind(mTableModel.get(position - 1));
    }

    @Override
    public int getItemViewType(int position) {

        if (position == 0) return VIEW_TYPE_TITLE;
        else return VIEW_TYPE_SUBTITLE;
    }

    @Override
    public int getItemCount() {
        return mTableModel.size() + 1;
    }

//    int index = -1;

//    @Override
//    public Filter getFilter() {
//
//        Filter filter = new Filter() {
//            @Override
//            protected FilterResults performFiltering(CharSequence constraint) {
//
//                String charString = constraint.toString();
//                if (charString.isEmpty()) {
//                    mTableModelDislay = mTableModel;
//                } else {
//                    List<InternationalCallDetailActivity.TableModel> filteredList = new ArrayList<>();
//                    InternationalCallDetailActivity.TableModel tableModel = new InternationalCallDetailActivity.TableModel(charString, new ArrayList<InternationalCallDetailActivity.TableSubModel>());
//                    index = mTableModel.indexOf(tableModel);
//                    if (index != -1) {
//                        filteredList.add(mTableModel.get(index));
//                    }
//
//                    mTableModelDislay = filteredList;
//                }
//
//                FilterResults filterResults = new FilterResults();
//                filterResults.values = mTableModelDislay;
//                return filterResults;
//            }
//
//            @Override
//            protected void publishResults(CharSequence constraint, FilterResults results) {
//                mTableModelDislay = (List<InternationalCallDetailActivity.TableModel>) results.values;
//                notifyDataSetChanged();
//                if (onFilterFinish != null) {
//                    onFilterFinish.onFinised(index, constraint.toString());
//                }
//            }
//        };
//        return filter;
//    }

    private OnFilter onFilterFinish;

    public OnFilter getOnFilterFinish() {
        return onFilterFinish;
    }

    public void setOnFilterFinish(OnFilter onFilterFinish) {
        this.onFilterFinish = onFilterFinish;
    }

    public interface OnFilter {
        void onFinised(int position, String contraint);
    }

    private class TitleViewHolder extends RecyclerView.ViewHolder {

        private TitleViewHolder(View itemView) {
            super(itemView);
        }

        private void onBind() {
        }
    }

    public class DetailViewHolder extends RecyclerView.ViewHolder {

        private final TextView mDataPack;
        private final RecyclerView recyclerViewSub;
        private final List<TableSubModel> tableSubModels = new ArrayList<>();
        public InternationalCallSubAdapter mAdapter;

        public DetailViewHolder(View itemView) {
            super(itemView);
            mDataPack = itemView.findViewById(R.id.text_view_data_pack);
            recyclerViewSub = itemView.findViewById(R.id.recycler_sub_international);

        }


        private void onBind(TableModel tableModel) {
            mDataPack.setText(tableModel.getStandard());
            recyclerViewSub.setLayoutManager(new LinearLayoutManager(mContext) {
                @Override
                public boolean canScrollVertically() {
                    return false;
                }
            });
            recyclerViewSub.setHasFixedSize(true);
            mAdapter = new InternationalCallSubAdapter(mContext, tableSubModels);
            recyclerViewSub.setAdapter(mAdapter);
            if (tableModel.getDestination() != null) {
                tableSubModels.clear();
                tableSubModels.addAll(tableModel.getDestination());
                mAdapter.notifyDataSetChanged();
            }

        }

//        public void setFilter(ArrayList<InternationalCallDetailActivity.TableModel> tableModels) {
//            mTableModel = new ArrayList<>();
//            mTableModel.addAll(tableModels);
//            notifyDataSetChanged();
//        }
    }
}
