package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ItemEshopBinding
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.interactor.ItemViewInteractor

class SupportAdapter(
    private val context: Context,
    private val itemViewInteractor: ItemViewInteractor
) : BaseAdapter<SupportAdapter.SupportVH>() {

    var dataList = ArrayList<String>()

    init {
        dataList.add(context.getString(R.string.faqs))
        dataList.add(context.getString(R.string.supported_device))
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): SupportVH {
        // Inflate the layout using ViewBinding
        val binding = ItemEshopBinding.inflate(LayoutInflater.from(context), parent, false)
        return SupportVH(binding)
    }

    override fun getItemCount(): Int {
        return dataList.size
    }

    override fun onBindViewHolder(holder: SupportVH, position: Int) {
        holder.bind(dataList[position], position)
    }

    inner class SupportVH(private val binding: ItemEshopBinding) : RecyclerView.ViewHolder(binding.root) {

        fun bind(name: String, position: Int) {
            binding.textEshopName.text = name

            // Set image based on position
            if (position == 0) {
                binding.imgEshop.setImageResource(R.drawable.ic_faq)
            } else {
                binding.imgEshop.setImageResource(R.drawable.ic_device_support)
            }

            // Optionally handle visibility if needed (e.g., animations)
            itemView.visibility = View.INVISIBLE
            setAnimations(itemView, position)

            // Handle item click
            itemView.setOnClickListener {
                itemViewInteractor.onClick(it, position)
            }
        }
    }
}
