package com.seatel.mobilehall.ui.usage.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.gson.Gson;
import com.seatel.mobilehall.R;
import com.seatel.mobilehall.ui.usage.interactor.BilingDetailListInteractor;
import com.seatel.mobilehall.ui.usage.model.BilingDetailModel;
import com.seatel.mobilehall.util.Constant;
import com.seatel.mobilehall.util.SeatelUtils;

import java.text.DecimalFormat;
import java.util.ArrayList;

public class VoiceBillingAdapter extends RecyclerView.Adapter<VoiceBillingAdapter.VoiceViewHolder> {
    private final Context mContext;

    private BilingDetailListInteractor.View mView;
    private ArrayList<BilingDetailModel> mReportModel = new ArrayList();
    private Boolean isAll = false;
    private Boolean isLoaded = true;
    private String typeBiling = Constant.VOICE;
    private Boolean isPostPaid = true;
    private final String typeTranslate;

    private ArrayList<VoiceModel> voiceModels;

    public VoiceBillingAdapter(Context mContext, boolean isPostPaid) {
        this.mContext = mContext;
        this.isPostPaid = isPostPaid;
        typeTranslate = SeatelUtils.translatForDialog(mContext, "Type:");
    }

    public void setBilingType(String typeBiling) {
        this.typeBiling = typeBiling;
    }

    public void setDataBiling(ArrayList<BilingDetailModel> reportModel) {
        mReportModel = reportModel;
    }

    public ArrayList<BilingDetailModel> getDataBiling() {
        return mReportModel;
    }

    public void setViewInteractor(BilingDetailListInteractor.View view) {
        this.mView = view;
    }

    public void clearData() {
        mReportModel = new ArrayList();
    }

    public void addItems(ArrayList<BilingDetailModel> dataItem) {
        mReportModel.addAll(dataItem);
        if (dataItem.size() == 0) {
            notifyDataSetChanged();
        }
        isAll = dataItem.size() == 0;
        notifyDataSetChanged();
        notifyItemRangeChanged(getItemCount(), mReportModel.size());
        setLoaded(false);
    }

    public void onScrollEvent(LinearLayoutManager linearLayoutManager) {

        int lastChild = linearLayoutManager.findLastVisibleItemPosition();
        if (lastChild + 1 >= getItemCount() - 1 && !isLoaded && !isAll) {
            if (mView != null)
                mView.onLoadMore();
            isLoaded = true;
        }
    }

    public void setLoaded(Boolean loaded) {
        isLoaded = loaded;
    }

    @NonNull
    @Override
    public VoiceViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new VoiceViewHolder(LayoutInflater.from(mContext).inflate(R.layout.item_voice_billing, parent, false));
    }

    @SuppressLint("SetTextI18n")
    @Override
    public void onBindViewHolder(@NonNull VoiceViewHolder holder, int position) {
        BilingDetailModel voiceModel = mReportModel.get(position);
        Gson gson = new Gson();
        Log.d("voiceBillingAdapter:>>>", "onBindViewHolder: " + gson.toJson(voiceModel));
     //   holder.typeInternet.setVisibility(View.GONE);
        holder.viewColumnLast.setVisibility(View.GONE);
        holder.menute.setVisibility(View.INVISIBLE);
        holder.imgFirst.setPadding(0, 0, 0, 0);
        switch (typeBiling) {
            case Constant.INTERNET:
                holder.typeInternet.setVisibility(View.VISIBLE);
                holder.timeLine.setVisibility(View.GONE);
                holder.timeRow.setVisibility(View.GONE);
                holder.viewColumnCenter.setVisibility(View.INVISIBLE);
                holder.viewColumnLast.setVisibility(View.VISIBLE);
                holder.imgThird.setVisibility(View.VISIBLE);
                holder.imgFirst.setImageResource(R.drawable.ic_internet_billing_parent);
                holder.imgFirst.setPadding(5, 5, 5, 5);
                holder.imgSecond.setImageResource(R.drawable.ic_price_biling);
                String typeSize = SeatelUtils.Companion.getTypeData(voiceModel.getUsed());
                holder.phoneNumber.setText(SeatelUtils.Companion.convertMbToSize(voiceModel.getUsed()) + " " + typeSize);
                holder.phoneNumber.setText(holder.phoneNumber.getText().toString().replace(",", "."));
                holder.second.setText("$" + voiceModel.getCost().toString());

                holder.typeInternet.setText(SeatelUtils.translatForDialog(mContext, voiceModel.getTypeInternet()));
                if (isPostPaid) {
                    holder.second.setVisibility(View.VISIBLE);
                    holder.imgSecond.setVisibility(View.VISIBLE);
                } else {
                    holder.second.setVisibility(View.GONE);
                    holder.imgSecond.setVisibility(View.GONE);
                }
                holder.price.setText("$" + voiceModel.getCost().toString());

                break;
            case Constant.SMS:
                holder.viewColumnCenter.setVisibility(View.INVISIBLE);
                holder.imgFirst.setImageResource(R.drawable.ic_sms_billing_parent);
                holder.imgSecond.setImageResource(R.drawable.ic_second_biling2);
                holder.phoneNumber.setText(SeatelUtils.Companion.phoneNumberFormat(voiceModel.getPhone()));
                holder.typeInternet.setText(SeatelUtils.translatForDialog(mContext, voiceModel.getPlanType()));
                holder.price.setText("$" + voiceModel.getCost().toString());
                holder.viewColumnLast.setVisibility(View.VISIBLE);
                holder.second.setVisibility(View.VISIBLE);
                break;
            default:
                holder.imgFirst.setImageResource(R.drawable.ic_billing_voice_parent);
                holder.imgSecond.setImageResource(R.drawable.ic_second_biling2);
                holder.typeInternet.setText(SeatelUtils.translatForDialog(mContext, voiceModel.getPlanType()));
                holder.viewColumnLast.setVisibility(View.VISIBLE);
                holder.phoneNumber.setText(SeatelUtils.Companion.phoneNumberFormat(voiceModel.getPhone()));
                holder.price.setText("$" + voiceModel.getCost().toString());
                double valSecond = voiceModel.getDuration();

                if (valSecond >= 60) {
                    String minuteStr = SeatelUtils.translatForDialog(mContext, "Min");
                    if (valSecond < 2)
                        minuteStr = SeatelUtils.translatForDialog(mContext, "Mins");
                    holder.second.setText(SeatelUtils.Companion.convertSecondToTime(valSecond) + " " + SeatelUtils.Companion.toCamelCase(minuteStr));
                } else {
//                    String secondStr = SeatelUtils.translatForDialog(mContext, "seconds");
                    String secondStr = SeatelUtils.translatForDialog(mContext, "sec");
                    if (valSecond < 2)
//                        secondStr = SeatelUtils.translatForDialog(mContext, "second");
                        secondStr = SeatelUtils.translatForDialog(mContext, "sec");
                    DecimalFormat format = new DecimalFormat("0.#");
                    holder.second.setText(format.format(valSecond) + " " + SeatelUtils.Companion.toCamelCase(secondStr));
                }
                break;
        }

        holder.date.setText(SeatelUtils.Companion.getDateTime("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "MMM dd, yyyy", voiceModel.getDate()));

        String strTime = SeatelUtils.Companion.getDateTime("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'",
                "hh:mm a", voiceModel.getDate()).replace("AM", "am")
                .replace("PM", "pm");
        holder.timeRow.setText(strTime);
    }

    @Override
    public int getItemCount() {
        return mReportModel.size();
    }

    public class VoiceViewHolder extends RecyclerView.ViewHolder {
        private final TextView date;
        private final TextView phoneNumber;
        private final TextView second;
        private final TextView price;
        private final TextView menute;
        private final TextView timeRow;
        private final TextView timeLine;
        private final TextView typeInternet;
        private final View viewColumnLast;
        private final View viewColumnCenter;
        private final ImageView imgFirst;
        private final ImageView imgSecond;
        private final ImageView imgThird;

        public VoiceViewHolder(View itemView) {
            super(itemView);
            date = itemView.findViewById(R.id.text_view_voice_billing);
            phoneNumber = itemView.findViewById(R.id.phone_number_billing);
            second = itemView.findViewById(R.id.second_billing);
            price = itemView.findViewById(R.id.price_billing);
            menute = itemView.findViewById(R.id.ctv_minutes);
            timeRow = itemView.findViewById(R.id.time_row);
            timeLine = itemView.findViewById(R.id.point);
            typeInternet = itemView.findViewById(R.id.type_internet);
            viewColumnLast = itemView.findViewById(R.id.view_last_column);
            viewColumnCenter = itemView.findViewById(R.id.view_center_row);
            imgFirst = itemView.findViewById(R.id.img_first);
            imgSecond = itemView.findViewById(R.id.img_second);
            imgThird = itemView.findViewById(R.id.img_third);
        }
    }

    //Voice Model
    public static class VoiceModel {
        private String date;
        private String phoneNumber;
        private float second;
        private double price;

        public VoiceModel(String date, String phoneNumber, float second, double price) {
            this.date = date;
            this.phoneNumber = phoneNumber;
            this.second = second;
            this.price = price;
        }

        public String getDate() {
            return date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getPhoneNumber() {
            return phoneNumber;
        }

        public void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public float getSecond() {
            return second;
        }

        public void setSecond(float secound) {
            this.second = secound;
        }

        public double getPrice() {
            return price;
        }

        public void setPrice(double price) {
            this.price = price;
        }
    }
}
