package com.seatel.mobilehall.ui.home.presenter

import android.content.Context
import com.android.volley.Request
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.ui.home.interactor.BadgesCountInteractor
import org.json.JSONObject

class BadgesCountPresenter(private var mContext: Context,
                           private var  mViewCountList: BadgesCountInteractor.View
) : BadgesCountInteractor.Presenter {

    private var bagesRequest: SeatelJSONObjectRequest? = null

    override fun onGetBadgesCount(phoneNumber: String) {
        getNotificationListRequest(phoneNumber).setOnErrorListener { error ->
            mViewCountList.responseCountFail(error)
        }.setOnResponseListener { response ->
            mViewCountList.responseCountSucceed(response as JSONObject)
        }.execute()
    }


    private fun getNotificationListRequest(phoneNumber: String): SeatelJSONObjectRequest {
        bagesRequest?.cancel()
        bagesRequest = object : SeatelJSONObjectRequest(mContext) {
            override fun getFunctionName(): String {

                return if (phoneNumber.isNotEmpty()) "users/$phoneNumber/badges" else ""
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }
        }
        return bagesRequest!!
    }

}