package com.seatel.mobilehall.util.customview

import android.app.Dialog
import android.content.Context
import android.graphics.Typeface
import android.os.Bundle
import android.view.View
import android.view.Window
import com.seatel.mobilehall.R
import com.seatel.mobilehall.util.FontCache
import com.seatel.mobilehall.util.lang.LanguageManager
import com.seatel.mobilehall.databinding.DialogItemAddedToCardBinding

/**
 * Dialog for when an item is added to the cart
 *
 * @author Noel
 * @version
 * @created on 20-Oct-18
 */
@Suppress("RECEIVER_NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS")
class DialogAddCart(context: Context) : Dialog(context, R.style.CustomDialog) {

    private lateinit var binding: DialogItemAddedToCardBinding
    var onItemClick: OnItemClick? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        window?.requestFeature(Window.FEATURE_NO_TITLE)

        // Initialize ViewBinding
        binding = DialogItemAddedToCardBinding.inflate(layoutInflater)
        setContentView(binding.root)

        init()
        initEvent()
    }

    private fun init() {
        setCancelable(false)

        // Apply custom font
        val customFont = FontCache.getFont(context, Typeface.NORMAL)
        val plain: Typeface = FontCache.get(context, customFont)

        // Set custom font on buttons using ViewBinding
        binding.buttonBuy.typeface = plain
        binding.buttonAddToCard.typeface = plain

        // Set button texts with translations
        binding.buttonBuy.text = LanguageManager(context).translateWords(
            context,
            context.resources.getString(R.string.continue_shopping)
        )
        binding.buttonAddToCard.text = LanguageManager(context).translateWords(
            context,
            context.resources.getString(R.string.go_to_cart)
        )
    }

    private fun initEvent() {
        // Set click listeners on buttons using ViewBinding
        binding.buttonAddToCard.setOnClickListener {
            dismiss()
            onItemClick?.onButtonAddToCartClick(it)
        }
        binding.buttonBuy.setOnClickListener {
            dismiss()
            onItemClick?.onButtonContinueBuyClick(it)
        }
    }

    interface OnItemClick {
        fun onButtonAddToCartClick(view: View)
        fun onButtonContinueBuyClick(view: View)
    }
}
