package com.seatel.mobilehall.util.dialogannouncement

import android.app.Dialog
import android.content.Context
import android.graphics.drawable.ColorDrawable
import android.view.View
import android.view.ViewGroup
import android.view.Window
import android.widget.ImageView
import android.widget.TextView
import com.seatel.mobilehall.R

class WinAngPavDialog(
    context: Context,
    thanksDescription: String = "",
    isWon: Boolean = true,
    title: String = ""
) : Dialog(context) {

    private var isDimissClose = false

    init {
        init(title, thanksDescription, isWon)
    }

    fun isDimissClose(): Boolean {
        return isDimissClose
    }

    private fun init(title: String, thanksDescription: String, isWon: Boolean) {
        requestWindowFeature(Window.FEATURE_NO_TITLE)
        setContentView(R.layout.layout_win_angpav)
        setCancelable(false)
        if (window != null) {
            window!!.setLayout(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.WRAP_CONTENT
            )
            window!!.attributes.windowAnimations = R.style.DialogAnimationScaleInOut
            window!!.setDimAmount(0.5f)
            window!!.setBackgroundDrawable(ColorDrawable(android.graphics.Color.TRANSPARENT))
        }
        findViewById<View>(R.id.button_yes).setOnClickListener { dismiss() }
        if (title.isNotEmpty())
            findViewById<TextView>(R.id.title_congratulations).text = title
        findViewById<TextView>(R.id.text_description).text = thanksDescription
        findViewById<ImageView>(R.id.img_close).setOnClickListener {
            isDimissClose = true
            dismiss()
        }
        if (!isWon) {
            setCancelable(true)
            findViewById<ImageView>(R.id.img_close).visibility = View.GONE
            findViewById<ImageView>(R.id.image_view_title).visibility = View.GONE
            if (title.isEmpty())
                findViewById<TextView>(R.id.title_congratulations).text = "Thank You!"
            findViewById<TextView>(R.id.button_yes).text = "Ok"
        }
    }
}
