package com.seatel.mobilehall.ui.yes_member.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import com.android.volley.VolleyError
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivityEarnCoinHistoryBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.yes_member.adapter.EarnCoinHistoryAdapter
import com.seatel.mobilehall.ui.yes_member.interactor.EarnCoinHistoryInteractor
import com.seatel.mobilehall.ui.yes_member.model.EarnCoinHistoryModel
import com.seatel.mobilehall.ui.yes_member.presenter.EarnCoinHistoryPresenter
import com.seatel.mobilehall.util.SeatelAlertDialog

class EarnCoinHistoryActivity : BaseActivity<ActivityEarnCoinHistoryBinding>(),
    EarnCoinHistoryInteractor.View {

    companion object {
        fun launch(context: Context) {
            val intent = Intent(context, EarnCoinHistoryActivity::class.java)
            context.startActivity(intent)
        }
    }

    override fun getViewBinding(): ActivityEarnCoinHistoryBinding {
        return ActivityEarnCoinHistoryBinding.inflate(layoutInflater)
    }


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        activityEnterRightAnimation()
        EarnCoinHistoryPresenter(this, this).getEarnCoinHistory(getPhoneLogin())
    }

    override fun responseEarnCoinHistorySucceed(earnCoinHistoryList: EarnCoinHistoryModel) {

        binding.recyclerCoinHistory.adapter = EarnCoinHistoryAdapter(this, earnCoinHistoryList.data)

    }

    override fun responseEarnCoinHistoryFail(error: VolleyError) {
        SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(error))
            .show()
    }

    override fun getStringToolbarTitle(): String? {
        return "Earn Coins History"
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
    }


}