package com.seatel.mobilehall.util.customview

import android.content.Context
import android.graphics.Matrix
import android.util.AttributeSet
import androidx.appcompat.widget.AppCompatImageView

class ImageViewFitYCropX @JvmOverloads constructor(context: Context?, attrs: AttributeSet? = null, defStyleAttr: Int = 0) : AppCompatImageView(context!!, attrs, defStyleAttr) {

    private val m = Matrix()


    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
        if (drawable != null) {
            val width = MeasureSpec.getSize(widthMeasureSpec)
            val height = width * drawable.intrinsicHeight / drawable.intrinsicWidth
            setMeasuredDimension(width, height)
        } else {
            setMeasuredDimension(widthMeasureSpec, heightMeasureSpec)
        }
    }
}