package com.seatel.mobilehall.ui.yes_member.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import com.android.volley.VolleyError
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivityRedeemBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.yes_member.interactor.RedeemCodeInteractor
import com.seatel.mobilehall.ui.yes_member.presenter.RedeemCodePresenter
import com.seatel.mobilehall.util.SeatelAlertDialog
import org.json.JSONObject

class RedeemActivity : BaseActivity<ActivityRedeemBinding>(), RedeemCodeInteractor.View {


    companion object {
        fun launch(context: Context) {
            val intent = Intent(context, RedeemActivity::class.java)
            context.startActivity(intent)
        }
    }

    override fun getViewBinding(): ActivityRedeemBinding {
        return ActivityRedeemBinding.inflate(layoutInflater)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        super.activityEnterRightAnimation()
        binding.ivBack.setOnClickListener {
            onBackPressed()
        }


        binding.btnRedeem.setOnClickListener {
            RedeemCodePresenter(this, this).onRedeemCode(
                "code",
                binding.edCode.text.toString(),
                getPhoneLogin()
            )
        }

    }


    override fun isDisplayToolbar(): Boolean {
        return false
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitLeftAnimation()
    }

    override fun onRedeemCodeSuccess(jsonObject: JSONObject) {

        val status = jsonObject.optString("status")
        val message = jsonObject.optString("message")
        val description = jsonObject.optString("description")

        SuccessRedeemActivity.launch(this, message, description)
    }

    override fun onRedeemCodeFailure(errorMessage: VolleyError) {
        SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(errorMessage))
            .show()
    }
}