package com.seatel.mobilehall.util.customview

import android.app.Dialog
import android.content.Context
import android.graphics.Typeface
import android.os.Bundle
import android.view.View
import android.view.Window
import com.seatel.mobilehall.R
import com.seatel.mobilehall.util.FontCache
import com.seatel.mobilehall.util.lang.LanguageManager
import kotlinx.android.synthetic.main.dialog_item_added_to_card.*

/**
 *
 *
 * @author Noel
 * @version
 * @created on 20-Oct-18
 */
@Suppress("RECEIVER_NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS")
class DialogAddCart(context: Context) : Dialog(context, R.style.CustomDialog) {
    var onItemClick: OnItemClick? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        window?.requestFeature(Window.FEATURE_NO_TITLE)
        setContentView(R.layout.dialog_item_added_to_card)
        init()
        initEvent()
    }

    private fun init() {
        setCancelable(false)
        val customFont = FontCache.getFont(context, Typeface.NORMAL)
        val plain: Typeface = FontCache.get(context, customFont)
        button_buy.typeface = plain
        button_add_to_card.typeface = plain
        button_buy.text = LanguageManager(context).translateWords(
            context,
            context.resources.getString(R.string.continue_shopping)
        )
        button_add_to_card.text = LanguageManager(context).translateWords(
            context,
            context.resources.getString(R.string.go_to_cart)
        )
    }

    private fun initEvent() {
        button_add_to_card.setOnClickListener {
            dismiss()
            onItemClick?.onButtonAddToCartClick(it)
        }
        button_buy.setOnClickListener {
            dismiss()
            onItemClick?.onButtonContinueBuyClick(it)
        }
    }

    interface OnItemClick {
        fun onButtonAddToCartClick(view: View)
        fun onButtonContinueBuyClick(view: View)
    }

}