package com.seatel.mobilehall.ui.home.activity

import android.annotation.SuppressLint
import android.os.Bundle
import android.widget.RelativeLayout
import androidx.coordinatorlayout.widget.CoordinatorLayout
import androidx.core.content.ContextCompat
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.util.BottomNavigationBehavior
import com.seatel.mobilehall.R
import kotlinx.android.synthetic.main.activity_data_pack_detail.*

@SuppressLint("Registered")
open class BaseProductAndServiceActivity : BaseActivity(), SwipeRefreshLayout.OnRefreshListener {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_data_pack_detail)
        activityEnterRightAnimation()
        if (isShowAddToCardButton()) {
            addShowButtonFooter()
        }

        swipe_refresh_layout.setColorSchemeColors(
            ContextCompat.getColor(
                this,
                R.color.colorPrimary
            )
        )
        //swipe_refresh_layout.setOnRefreshListener(this)
        swipe_refresh_layout.isRefreshing = false
        swipe_refresh_layout.isEnabled = false
    }

    private fun addShowButtonFooter() {
        val navigation = findViewById<RelativeLayout>(R.id.data_pack_bottom_navigation)
        val navigationBackground =
            findViewById<RelativeLayout>(R.id.data_pack_bottom_navigation_background)
        val layoutParams = navigation.layoutParams as CoordinatorLayout.LayoutParams
        val layoutParamsBackground =
            navigationBackground.layoutParams as CoordinatorLayout.LayoutParams

        scroll_data_pack.viewTreeObserver.addOnGlobalLayoutListener {
            val bottomNavigationBehavior = BottomNavigationBehavior(440)
            val bottomNavigationBehaviorBackground = BottomNavigationBehavior(300)
            bottomNavigationBehavior.showBottomNavigationView(navigation)
            bottomNavigationBehaviorBackground.showBottomNavigationView(navigationBackground)
            if (getHeight(scroll_data_pack) < getHeight(recycler_view_product_service) + 30) {

                layoutParams.behavior = bottomNavigationBehavior
                layoutParamsBackground.behavior = bottomNavigationBehaviorBackground
            }
            scroll_data_pack.viewTreeObserver.removeOnGlobalLayoutListener { this }
        }
    }

    fun setShowButton(show: Boolean) {
        addShowButtonFooter()
    }

    open fun isShowAddToCardButton(): Boolean {
        return true
    }

    override fun onBackPressed() {
        super.onBackPressed()
        activityExitLeftAnimation()
    }

    override fun getStringToolbarTitle(): String? {
        return getString(R.string.data_pack_title)
    }

    override fun onRefresh() {
    }


}