package com.seatel.mobilehall.ui.game

import android.content.Context
import android.content.res.ColorStateList
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.util.SeatelUtils

class GameRewardAdapter(
    private var mContext: Context,
    private var angPaoListItem: ArrayList<GameModel>,
    private var rowClick: (index: GameModel) -> Unit
) :
    BaseAdapter<GameRewardAdapter.YesAngPaoViewHolder>() {


    class YesAngPaoViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val valentinePrize = itemView.findViewById<TextView>(R.id.valentine_data)
        val valentineUseFor = itemView.findViewById<TextView>(R.id.valentine_use_for)
        val valentineValidity = itemView.findViewById<TextView>(R.id.valentine_validity)
        val valentineBtnClaim = itemView.findViewById<Button>(R.id.btn_claim_valentine)
    }

    override fun onCreateViewHolder(
        parent: ViewGroup,
        viewType: Int
    ): YesAngPaoViewHolder {
        return YesAngPaoViewHolder(
            LayoutInflater.from(mContext).inflate(R.layout.item_game_reward, parent, false)
        )
    }

    override fun onBindViewHolder(
        holder: YesAngPaoViewHolder,
        position: Int
    ) {
        // holder.itemView.visibility = View.INVISIBLE
        setAnimations(holder.itemView, position)
        val data = angPaoListItem[position]
        holder.valentinePrize.text = data.prize
        holder.valentineUseFor.text = " ${data.usefor}"
        val winDate = SeatelUtils.getDateTime(
            "yyyy-MM-dd", "dd/MM/YYYY",
            data.winDate
        )
        val mValidity = SeatelUtils.getDateTime(
            "yyyy-MM-dd", "dd/MM/YYYY",
            data.validity
        )
        holder.valentineValidity.text = " $winDate - $mValidity"

        holder.valentineBtnClaim.text = data.status
        if (data.claimed) {
            holder.valentineBtnClaim.backgroundTintList =
                ColorStateList.valueOf(mContext.getColor(R.color.color_claim_gray))
        } else {
            holder.valentineBtnClaim.backgroundTintList =
                ColorStateList.valueOf(mContext.getColor(R.color.colorPrimary))
            holder.valentineBtnClaim.setOnClickListener {
                data.let(rowClick)
            }
        }

    }

    override fun getItemCount(): Int {
        return angPaoListItem.size
    }
}