package com.seatel.mobilehall.ui.profile.activity

import ProductServicesAdapter
import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.android.volley.NoConnectionError
import com.android.volley.TimeoutError
import com.android.volley.VolleyError
import com.seatel.mobilehall.BuildConfig
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.prefs.SeatelSharePreferences
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.activity.InternationalCallDetailActivity
import com.seatel.mobilehall.ui.home.activity.OnePlanDetailActivity
import com.seatel.mobilehall.ui.home.activity.ProductServiceDetailActivity
import com.seatel.mobilehall.ui.home.interactor.AppProductsInteractor
import com.seatel.mobilehall.ui.home.model.AppProductsResponseModel
import com.seatel.mobilehall.ui.home.model.MainDataModel
import com.seatel.mobilehall.ui.home.presenter.AppProductsPresenter
import com.seatel.mobilehall.util.SeatelUtils
import com.google.gson.Gson
import com.seatel.mobilehall.ui.home.activity.LoyKobActivity
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.customview.ErrorHandleView
import kotlinx.android.synthetic.main.activity_get_more_data.*

class GetMoreDataActivity : BaseActivity(), AppProductsInteractor.View {

    private val productService: ArrayList<AppProductsResponseModel> = ArrayList()
    private var dataMainScreen: MainDataModel? = null
    private var mAppProductsPresenter: AppProductsPresenter? = null

    private var isOnlyDisplay = false
    private var layoutManager: RecyclerView.LayoutManager? = null
    var canSubscribe: Boolean = false

    override fun onGetAppProductsSucceed(appProductsList: ArrayList<AppProductsResponseModel>) {
        if (appProductsList.size == 0) {
            isOnlyDisplay = true
            productService.add(
                AppProductsResponseModel(
                    "internet-pack",
                    "Internet Pack",
                    "${BuildConfig.BASE_URL}uploads/internet-pack.png",
                    "5cd145dd4020a104f400d45b"
                )
            )
        } else {
            isOnlyDisplay = false
            productService.addAll(appProductsList)
        }
        setAdapterData()
        error_view.visibility = View.GONE
    }

    override fun onGetAppProductsFailed(error: VolleyError) {
        isOnlyDisplay = false
        when (error) {
            is TimeoutError -> {
                error_view.errorMessage = getString(R.string.connection_timeout)
                error_view.setViewMode(ErrorHandleView.Mode.TIME_OUT)
            }

            is NoConnectionError -> {
                error_view.errorMessage = getString(R.string.message_no_internet)
                error_view.setViewMode(ErrorHandleView.Mode.NO_INTERNET)
            }

            else -> {
                error_view.errorMessage = getString(R.string.no_data)
                error_view.setViewMode(ErrorHandleView.Mode.NO_DATA)
            }
        }
    }

    private fun setAdapterData() {
        if (productService.size > 0) {
            for (i in 0 until productService.size) {
                canSubscribe = productService[i].canSubscribe!!

            }
        }

        getmoredata_recycler_view.adapter = ProductServicesAdapter(this, productService) {
            when (it.code) {
                "one-plan" -> {
                    OnePlanDetailActivity.lunch(this)
                }

                "free-internet-promotion" -> {
                    /*  FreePromotionDetailActivity.lunch(
                          this,
                          getString(R.string.free_internet_promotion)
                      )*/
                }

                "international-call" -> {
                    error_view.setViewMode(ErrorHandleView.Mode.LOADING)
                    InternationalCallDetailActivity.lunch(this)
                }

                "loy-kobs" -> LoyKobActivity.launch(
                    this,
                    it.canSubscribe!!,
                    it.code!!,
                    Constant.LoyKob
                )

                else -> {
                    LoyKobActivity.launch(this, it.canSubscribe!!, it.code!!, "Any")
                }
            }

        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        activityEnterRightAnimation()
        setContentView(R.layout.activity_get_more_data)
        layoutManager = LinearLayoutManager(this)
        getmoredata_recycler_view.layoutManager = layoutManager
        error_view.setViewMode(ErrorHandleView.Mode.LOADING)
        mAppProductsPresenter = AppProductsPresenter(this, this)
        mAppProductsPresenter?.setTypeQuery("add-on")
        mAppProductsPresenter?.onGetAppProducts(getPhoneLogin())

        dataMainScreen = Gson().fromJson<MainDataModel>(
            SeatelSharePreferences.getInstance(this)?.getMainScreenData(),
            MainDataModel::class.java
        )
        if (dataMainScreen != null) {
            ctv_user_name.text = dataMainScreen!!.getCustName()
            ctv_phone_number.text = SeatelUtils.phoneNumberFormat(dataMainScreen!!.getPhonNumber())
        }

    }


    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, GetMoreDataActivity::class.java)
            context.startActivity(intent)
        }
    }

    override fun onBackPressed() {
        super.onBackPressed()
        activityExitLeftAnimation()
    }

    override fun getToolbarTitle(): String {
        return resources.getString(R.string.get_more_data)
    }

}
