package com.seatel.mobilehall.ui.profile.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.os.Handler
import android.text.TextUtils
import android.view.View
import android.view.View.SCROLL_AXIS_HORIZONTAL
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.profile.interactor.NewPasswordInteractor
import com.seatel.mobilehall.ui.profile.presenter.NewPasswordPresenter
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.customview.ErrorHandleView
import kotlinx.android.synthetic.main.activity_change_password.*
import kotlinx.android.synthetic.main.activity_home.*

class ChangePasswordActivity : BaseActivity(), NewPasswordInteractor.View {
    private lateinit var mNewPasswordPresenter: NewPasswordPresenter
    private lateinit var mNewPasswordInteractor: NewPasswordInteractor.View

    private var mCurrentPassword = ""
    private var mNewPassword = ""
    private var mConfirmNewPassword = ""
    private var mPhoneNumber = ""

    override fun onNewPassSucceed() {
        ChangePasswordCompletedActivity.lunch(this)
        error_view.visibility = View.GONE
        finish()
    }

    override fun onNewPassFailed(error: VolleyError) {
        error_view.visibility = View.GONE
        SeatelUtils.showErrorDialog(this, SeatelSuperRequest.getErrorMessageFrom(error))
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        activityEnterUpAnimation()
        setContentView(R.layout.activity_change_password)
        image_view_close.setOnClickListener { onBackPressed() }
        mPhoneNumber = getMainPhoneLogin()
        mNewPasswordInteractor = this
        mNewPasswordPresenter = NewPasswordPresenter(this, mNewPasswordInteractor)
        button_yes.setOnClickListener {
            SeatelUtils.hideKeyboard(this)
            if (checkValidate()) {
                error_view.setViewMode(ErrorHandleView.Mode.LOADING)
                mNewPasswordPresenter.onSetNewPassword(mPhoneNumber, mCurrentPassword, mNewPassword)
            }
        }
        ctv_current_password.hint = ctv_current_password.hint
        ctv_new_password.hint = ctv_new_password.hint
        ctv_confirm_new_password.hint = ctv_confirm_new_password.hint

        layout_main.setOnClickListener {
            SeatelUtils.hideKeyboard(this)
        }
        initParallaxView()
    }

    private fun checkValidate(): Boolean {
        mCurrentPassword = ctv_current_password.text.toString().trim()
        mNewPassword = ctv_new_password.text.toString().trim()
        mConfirmNewPassword = ctv_confirm_new_password.text.toString().trim()

        var msg = ""

        if (mCurrentPassword.isEmpty())
            msg = getString(R.string.current_password_empty)
        else if (mNewPassword.isEmpty())
            msg = getString(R.string.new_password_empty)
        else if (mConfirmNewPassword.isEmpty())
            msg = getString(R.string.confirm_new_password_empty)
        else if (!TextUtils.equals(mNewPassword, mConfirmNewPassword))
            msg = getString(R.string.confirm_new_password_not_match)
        else if (mCurrentPassword.length < 6)
            msg = getString(R.string.current_password_at_least_6_digit)
        else if (mNewPassword.length < 6)
            msg = getString(R.string.password_at_least_6_digit)

        if (!TextUtils.isEmpty(msg)) {
            SeatelAlertDialog.with(this, msg).show()
            return false
        }
        return true
    }

    override fun onBackPressed() {
        super.onBackPressed()
        activityExitDownAnimation()
    }

    private fun initParallaxView() {
        parallax_view_sky_line.setActualImageResource(R.drawable.sky_line_bg)
        parallax_view_sky_line.canScrollHorizontally(SCROLL_AXIS_HORIZONTAL)
        parallax_view_sky_line.visibility = View.VISIBLE

//        parallax_view_sky_line.viewTreeObserver.add

        Handler().postDelayed({
            parallax_view_sky_line.setOffset(0.5f)
            scrollBackgroundY(true)

        }, 200)

    }

    private fun scrollBackgroundY(isScrollUp: Boolean) {

//        val displayMetrics = DisplayMetrics()
//        this.windowManager.defaultDisplay.getMetrics(displayMetrics)

        val targetPos = (SeatelUtils.getDisplayMetrics(this).heightPixels / 2 -
                (parallax_view_sky_line.height / 2 + SeatelUtils.convertDpToPx(this, 10)))
        if (isScrollUp) translateY(-targetPos.toFloat())
        else translateY(0f)

    }

    private fun translateY(targetPos: Float) {
        parallax_view_sky_line.visibility = View.VISIBLE
        parallax_view_sky_line.animate().translationY(targetPos).duration = 200
        view.animate().translationY(targetPos).duration = 200
    }

    override fun isDisplayToolbar(): Boolean {
        return false
    }

    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, ChangePasswordActivity::class.java)
            context.startActivity(intent)
        }
    }
}


