package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.activity.YesHubNearestActivity
import com.seatel.mobilehall.ui.home.interactor.LocationShopMapInteractor
import com.seatel.mobilehall.ui.home.model.SeatelShopLocationModel
import com.seatel.mobilehall.util.SeatelUtils
import kotlinx.android.synthetic.main.item_nearest_yes_hub_location.view.*


class NearestYesHubLocationAdapter(
    private var items: ArrayList<SeatelShopLocationModel>,
    val context: Context
) : BaseAdapter<NearestYesHubLocationAdapter.ViewHolder>() {

    private var isShowOnlyLocalArea = false
    private lateinit var mLocationInterator: LocationShopMapInteractor
    private var positionSelect = -1

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        return ViewHolder(
            LayoutInflater.from(context)
                .inflate(R.layout.item_nearest_yes_hub_location, parent, false)
        )
    }

    fun setClickLocalAreaSearch(onstartSearch: LocationShopMapInteractor) {
        this.mLocationInterator = onstartSearch
    }

    fun removeAll() {
        items = ArrayList<SeatelShopLocationModel>()
        notifyDataSetChanged()
    }

    fun updatedDataLocation(item: ArrayList<SeatelShopLocationModel>, showName: Boolean) {
//        this.items.clear()
        this.items.addAll(item) //= ArrayList<SeatelShopLocationModel>(items)
        this.isShowOnlyLocalArea = showName
        notifyDataSetChanged()

    }

    override fun getItemCount(): Int {
        return items.size
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
//        if (getLastPosition() == -1) {
//            holder.itemView.visibility = View.INVISIBLE
//        }
//        setAnimation(holder.itemView, position)

        holder.bindView(items[position], isShowOnlyLocalArea)
        holder.itemView.setBackgroundColor(
            ContextCompat.getColor(
                context,
                android.R.color.transparent
            )
        )
        holder.itemView.setOnClickListener {
            if (isShowOnlyLocalArea) {
                holder.itemView.setBackgroundColor(
                    ContextCompat.getColor(
                        context,
                        android.R.color.transparent
                    )
                )
                positionSelect = -1
                (context as YesHubNearestActivity).showYesButton(positionSelect, null)
                mLocationInterator.onStartSearch(items[position].localArea)
            } else {
//                ContactUsActivity.launch(context, Gson().toJson(items[position]))
                if (positionSelect == position) {
                    positionSelect = -1
                    holder.itemView.setBackgroundColor(
                        ContextCompat.getColor(
                            context,
                            android.R.color.transparent
                        )
                    )
                    holder.itemView.btn_check.visibility = View.INVISIBLE
                    (context as YesHubNearestActivity).showYesButton(positionSelect, null)
                } else {
                    notifyItemChanged(positionSelect)
                    positionSelect = position
                    holder.itemView.setBackgroundColor(
                        ContextCompat.getColor(
                            context,
                            R.color.colorPinkSoft
                        )
                    )
                    holder.itemView.btn_check.visibility = View.VISIBLE

                    (context as YesHubNearestActivity).showYesButton(position, items[position])
                }
            }
        }

        if (isShowOnlyLocalArea) {
            holder.itemView.btn_check.visibility = View.GONE
            holder.itemView.tv_phone.visibility = View.GONE
            holder.itemView.tv_title.visibility = View.GONE
            holder.itemView.img_call.visibility = View.GONE
        } else {
            if (positionSelect == position) {
                holder.itemView.btn_check.visibility = View.VISIBLE
            } else {
                holder.itemView.btn_check.visibility = View.INVISIBLE
            }
            holder.itemView.tv_phone.visibility = View.VISIBLE
            holder.itemView.tv_title.visibility = View.VISIBLE
            holder.itemView.img_call.visibility = View.VISIBLE
        }

//        holder.itemView.phone_call.setOnClickListener {
//            (context as YesHubNearestActivity).showCallDialog(items[position].contactNumber)
//        }
    }

    class ViewHolder(view: View) : RecyclerView.ViewHolder(view) {
        var isShowLocalArea = false
        val tvTitle = view.tv_title
        val tvAddress = view.tv_address
        val tvPhone = view.tv_phone

        fun bindView(rowData: SeatelShopLocationModel, showLocalArea: Boolean) {
            isShowLocalArea = showLocalArea
            if (isShowLocalArea)
                tvAddress.text = rowData.localArea
            else
                tvAddress.text = rowData.address

            tvTitle.text = rowData.name
            tvPhone.text = SeatelUtils.getPhoneFormatWithOutCode(rowData.contactNumber)
        }
    }

}