package com.seatel.mobilehall.ui.home.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.os.Message
import android.text.TextUtils
import android.util.Log
import android.view.View
import com.google.gson.Gson
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.model.ValuePackTableModel
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelUtils
import kotlinx.android.synthetic.main.activity_confirm_buy_data_pack.*
import kotlinx.android.synthetic.main.activity_success_buy_data_pack.*

class SuccessBuyDataPackActivity : BaseActivity() {

    private var isValuePack = false
    private var isVipFortune = false
    private var isFortune = false
    private var mDataValuePack: ValuePackTableModel? = null
    private var type: String = ""
    private var data: String = ""
    private var isAddON: Boolean = false
    private var message: String? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_success_buy_data_pack)
        activityEnterUpAnimation()
        getData()

    }

    private fun getData() {
        type = intent.getStringExtra("TYPE_PLAN").toString()
        data = intent.getStringExtra("DATA").toString()
        isAddON = intent.getBooleanExtra("IS_ADD_ON", false)
        message = intent.getStringExtra("message").toString()
        Log.d("TAG::>>>", "getData: $message")

        if (message.equals("null") || message.isNullOrEmpty()) {
            text_view_to.visibility = View.VISIBLE
            tv_account.text = getPhoneLogin()
            if (isAddON) text_view_top_up.text = "Buy $type Add On"
            else text_view_top_up.text = "Buy $type"
            text_view_top_up_amount.text = data
        } else {
            text_view_top_up.text = message
        }

        image_view_go_to_main.setOnClickListener {
            gotoMainScreen()
            finish()
        }
    }

    private fun init() {
        image_view_go_to_main.setOnClickListener {
            gotoMainScreen()
            finish()
        }
        if (isValuePack) {
            img_value_pack.visibility = View.VISIBLE
            text_view_top_up.visibility = View.GONE
            ctv_size.visibility = View.GONE
            text_view_top_up_amount.text =
                "${SeatelUtils.displayAmountNoDecial(mDataValuePack?.valuePrice.toString())} = ${
                    SeatelUtils.displayAmountNoDecial(mDataValuePack?.priceChange.toString())
                }"
            text_view_to.text =
                SeatelUtils.translatForDialog(this, getString(R.string.is_now_activate))
            tv_account.text = SeatelUtils.phoneNumberFormat(getPhoneLogin())

        } else if (isFortune) {
            // text_view_top_up.visibility = View.GONE
            ctv_size.visibility = View.GONE
            text_view_top_up.text = " Buy Fortune Pack"
            text_view_top_up_amount.text =
                "${SeatelUtils.displayAmountNoDecial(mDataValuePack?.valuePrice.toString())} = ${
                    SeatelUtils.displayAmountNoDecial(mDataValuePack?.priceChange.toString())
                }"
            text_view_to.text =
                SeatelUtils.translatForDialog(this, getString(R.string.is_now_activate))
            tv_account.text = SeatelUtils.phoneNumberFormat(getPhoneLogin())
        } else if (isVipFortune) {
            //  text_view_top_up.visibility = View.GONE
            ctv_size.visibility = View.GONE
            text_view_top_up.text = "Buy VIP Fortune Pack"
            text_view_top_up_amount.text =
                "${SeatelUtils.displayAmountNoDecial(mDataValuePack?.valuePrice.toString())} = ${
                    SeatelUtils.displayAmountNoDecial(mDataValuePack?.priceChange.toString())
                }"
            text_view_to.text =
                SeatelUtils.translatForDialog(this, getString(R.string.is_now_activate))
            tv_account.text = SeatelUtils.phoneNumberFormat(getPhoneLogin())
        } else {
            val amountTotal = intent.getStringExtra(Constant.SUCCESS_VALUE_TOP)
            if (intent.getBooleanExtra(Constant.LAUNCH_FROM, false)) {
                text_view_top_up.text = getString(R.string.buy_freedom_internet)
                text_view_top_up_amount.text = intent.getStringExtra(Constant.SUCCESS_VALUE_TOP)
            } else {
                if (!TextUtils.isEmpty(amountTotal)) {
                    ctv_size.text = amountTotal!!.takeLast(2)
                    text_view_top_up_amount.text =
                        amountTotal.subSequence(0, amountTotal.length - 2)
                }
            }

            tv_account.text = intent.getStringExtra(Constant.SUCCESS_VALUE_BOTTOM)
        }
    }

    private fun getDataIntent() {
        if (intent.hasExtra("IS_VALUE_PACK")) isValuePack =
            intent.getBooleanExtra("IS_VALUE_PACK", false)
        if (intent.hasExtra("VALUE_PACK_DATA")) mDataValuePack = Gson().fromJson(
            intent.getStringExtra("VALUE_PACK_DATA"), ValuePackTableModel::class.java
        )
        if (intent.hasExtra("IS_FORTUNE_PACK")) isFortune =
            intent.getBooleanExtra("IS_FORTUNE_PACK", false)
        if (intent.hasExtra("IS_VIP_FORTUNE_PACK")) isVipFortune =
            intent.getBooleanExtra("IS_VIP_FORTUNE_PACK", false)

    }


    override fun onBackPressed() {
        super.onBackPressed()
        activityExitDownAnimation()
    }

    override fun isDisplayToolbar(): Boolean {
        return false
    }

    companion object {

        fun launch(context: Context, typePlan: String, data: String, isAddOn: Boolean) {
            val intent = Intent(context, SuccessBuyDataPackActivity::class.java)
            intent.putExtra("TYPE_PLAN", typePlan)
            intent.putExtra("DATA", data)
            intent.putExtra("IS_ADD_ON", isAddOn)
            context.startActivity(intent)
        }

        fun lunch(context: Context, valueTop: String, valueBottom: String, freedom: Boolean) {
            val intent = Intent(context, SuccessBuyDataPackActivity::class.java)
            intent.putExtra(Constant.SUCCESS_VALUE_TOP, valueTop)
            intent.putExtra(Constant.SUCCESS_VALUE_BOTTOM, valueBottom)
            intent.putExtra(Constant.LAUNCH_FROM, freedom)
            context.startActivity(intent)
        }

        fun launchSwitchPlan(context: Context, message: String) {
            val intent = Intent(context, SuccessBuyDataPackActivity::class.java)
            intent.putExtra("message", message)
            context.startActivity(intent)
        }

        fun lunchFromValuePack(
            context: Context,
            dataValuePack: ValuePackTableModel,
            isFortunePlan: Boolean = false,
            isVipFortunePlan: Boolean = false
        ) {
            val intent = Intent(context, SuccessBuyDataPackActivity::class.java)
            when {
                isFortunePlan -> {
                    intent.putExtra("IS_FORTUNE_PACK", true)
                }

                isVipFortunePlan -> {
                    intent.putExtra("IS_VIP_FORTUNE_PACK", true)
                }

                else -> {
                    intent.putExtra("IS_VALUE_PACK", true)
                }
            }
            intent.putExtra("VALUE_PACK_DATA", Gson().toJson(dataValuePack))
            context.startActivity(intent)
        }
    }
}
