package com.seatel.mobilehall.ui.game

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.os.Handler
import android.view.View
import android.view.View.OnClickListener
import com.android.volley.Request
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.ActivityGameBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.customview.ErrorHandleView
import com.seatel.mobilehall.util.dialogannouncement.CustomGameDialog
import com.seatel.mobilehall.util.viewBinding
import kotlinx.android.synthetic.main.activity_game.btn_center
import kotlinx.android.synthetic.main.activity_game.btn_claim
import kotlinx.android.synthetic.main.activity_game.btn_left
import kotlinx.android.synthetic.main.activity_game.btn_right
import kotlinx.android.synthetic.main.activity_game.error_view
import kotlinx.android.synthetic.main.activity_game.imageViewBack
import org.json.JSONObject

class GameActivity : BaseActivity(), OnClickListener {


    private val binding by viewBinding(
        ActivityGameBinding::inflate
    )

    private var mChance: Int = 0
    private var mTitle: String = ""
    private var mPrize: String = ""
    private var mSubTitle: String = ""
    private var mImage: String = ""

    private var isButtonClickable = true

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(binding.root)
        init()
    }


    private fun init() {
        btn_left.setOnClickListener(this)
        btn_center.setOnClickListener(this)
        btn_right.setOnClickListener(this)
        btn_claim.setOnClickListener(this)
        imageViewBack.setOnClickListener(this)
    }


    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, GameActivity::class.java)
            context.startActivity(intent)
        }

    }

    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.btn_left -> {
                if (isButtonClickable) {
                    // Disable the button to prevent multiple clicks
                    disableButton()

                    // Do your button click logic here
                    // ...
                    requestChance()

                    // Example: simulate a delay and then re-enable the button
                    Handler().postDelayed({
                        enableButton()
                    }, 1000)  // 1000 milliseconds delay
                }

            }

            R.id.btn_center -> {
                requestChance()
            }

            R.id.btn_right -> {
                requestChance()
            }

            R.id.btn_claim -> {
                GameRewardActivity.launch(this)
            }

            R.id.imageViewBack -> onBackPressed()
        }
    }

    private fun disableButton() {
        isButtonClickable = false
        btn_left.isEnabled = false
    }

    private fun enableButton() {
        isButtonClickable = true
        btn_left.isEnabled = true
    }

    private fun requestChance() {
        error_view.setViewMode(ErrorHandleView.Mode.LOADING)
        object : SeatelJSONObjectRequest(this) {
            override fun getFunctionName(): String {
                return "v2/seatel/get-chance/${getPhoneLogin()}/mystery-box"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }

        }.setOnErrorListener {
            error_view.visibility = View.GONE
            SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(it)).show()

        }.execute {
            error_view.visibility = View.GONE
            mChance = (it as JSONObject).optInt("chance")
            if (mChance > 0) {
                randomGame()
            } else SeatelAlertDialog.with(
                this,
                applicationContext.getString(R.string.game_no_chance)
            ).show()
        }

    }

    private fun randomGame() {
        object : SeatelJSONObjectRequest(this) {
            override fun getFunctionName(): String {
                return "v2/seatel/get-angpao/${getPhoneLogin()}/mystery-box"
            }

            override fun getMethod(): Int {
                return Request.Method.GET
            }

        }.setOnErrorListener {
            SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(it)).show()

        }.execute {

            val data = it as JSONObject
            mTitle = data.optString("title")
            mPrize = data.optString("prize")
            mSubTitle = data.optString("subtitle")
            mImage = data.optString("image")

            val valentineDialog = CustomGameDialog(this, mTitle, mPrize, mSubTitle, mImage, false)
            valentineDialog.show()

        }
    }

}

