package com.seatel.mobilehall.util.dialogannouncement

import android.app.Dialog
import android.content.Context
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.view.View
import android.view.ViewGroup
import android.view.Window
import android.widget.Button
import android.widget.ImageView
import android.widget.TextView
import coil.load
import com.seatel.mobilehall.R
import com.seatel.mobilehall.util.lang.LanguageManager

class CustomGameDialog(
    context: Context,
    title: String,
    prize: String,
    subtitle: String,
    image: String,
    isDoneShow: Boolean
) : Dialog(context) {

    private var isDimissClose = false

    init {
        initValentine(title, prize, subtitle, image, isDoneShow)
    }

    fun isDimissClose(): Boolean {
        return isDimissClose
    }

    private fun initValentine(
        title: String, prize: String, subtitle: String, image: String, isDoneShow: Boolean
    ) {
        requestWindowFeature(Window.FEATURE_NO_TITLE)
        setContentView(R.layout.dialog_game)
        setCancelable(false)
        if (window != null) {
            window!!.setLayout(
                ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT
            )
            window!!.attributes.windowAnimations = R.style.DialogAnimationScaleInOut
            window!!.setDimAmount(0.5f)
            window!!.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
        }

        val mTitle = findViewById<TextView>(R.id.tv_congratulation)
        val mPrize = findViewById<ImageView>(R.id.iv_data)
        val mSubTitle = findViewById<TextView>(R.id.sub_title)
        // val mSubTitle = findViewById<TextView>(R.id.valentine_subTitle)
        val btnDone = findViewById<Button>(R.id.btn_done)
        val bgImage = findViewById<ImageView>(R.id.imageView2)
        val imageOpenAngPao = findViewById<ImageView>(R.id.image_open_ang_pao)
        btnDone.text = LanguageManager(context).translateWords(
            context, context.resources.getString(R.string.done)
        )
        if (title == "Thank You") {
            mTitle.text = ""
        } else mTitle.text = title/* if (prize.isEmpty()) {
             mPrize.visibility = View.GONE
         } else*/
        if (image.isNotBlank()) mPrize.load(image) { crossfade(true) }
        else mPrize.visibility = View.GONE

        mSubTitle.text = subtitle


        if (isDoneShow) {
            btnDone.visibility = View.VISIBLE
            bgImage.setImageDrawable(context.resources.getDrawable(R.drawable.bg_dialog_game))
        } else {
            btnDone.visibility = View.GONE
            imageOpenAngPao.visibility = View.VISIBLE
        }
        btnDone.setOnClickListener {
            dismiss()
        }
        val close = findViewById<ImageView>(R.id.valentine_close)
        close.setOnClickListener {
            dismiss()

        }
    }

}