package com.seatel.mobilehall.ui.packages.adapter

import android.content.Context
import android.graphics.Color
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.model.AppProductsResponseModel
import kotlinx.android.synthetic.main.item_package_product_service.view.frame_parent

class ProductServicePackageAdapter(
    private var mContext: Context,
    private var productsList: ArrayList<AppProductsResponseModel>,
    private var rowClick: (index: AppProductsResponseModel) -> Unit
) : BaseAdapter<ProductServicePackageAdapter.ProductServiceViewHolder>() {

    private var selectedItemPosition: Int = 0

    class ProductServiceViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var mIcon = itemView.findViewById<ImageView>(R.id.ivIcon)
        var mTitle = itemView.findViewById<TextView>(R.id.tvTitle)
        var background = itemView.findViewById<ConstraintLayout>(R.id.frame_parent)

    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ProductServiceViewHolder {
        return ProductServiceViewHolder(
            LayoutInflater.from(mContext)
                .inflate(R.layout.item_package_product_service, parent, false)
        )
    }

    override fun onBindViewHolder(holder: ProductServiceViewHolder, position: Int) {
        //  holder.itemView.visibility = View.INVISIBLE
        setAnimations(holder.itemView, position)
        val serviceModel = productsList[position]
        holder.mTitle.text = serviceModel.name
        Glide.with(mContext).load(serviceModel.icon).into(holder.mIcon)
        holder.itemView.frame_parent.setOnClickListener {
            serviceModel.let(rowClick)
            selectedItemPosition = holder.adapterPosition
            notifyDataSetChanged()
        }

        if (selectedItemPosition == position) {
            holder.background.setBackgroundColor(Color.parseColor("#ffffffff"))
        } else {
            holder.background.setBackgroundColor(Color.parseColor("#f0f1f1"))
        }
    }

    override fun getItemCount(): Int {
        return productsList.size
    }
}