package com.seatel.mobilehall.ui.main

import android.content.Context
import android.content.Intent
import android.os.Bundle
import androidx.navigation.NavController
import androidx.navigation.findNavController
import androidx.navigation.ui.setupWithNavController
import com.google.android.material.bottomnavigation.BottomNavigationView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.databinding.ActivityMainBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.util.SeatelUtils.Companion.translatForDialog
import com.seatel.mobilehall.util.viewBinding

class MainActivity : BaseActivity() {

    private val binding by viewBinding(
        ActivityMainBinding::inflate
    )


    private lateinit var navController: NavController

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(binding.root)
        setupBottomNav()

    }

    private fun setupBottomNav() {
        val navView: BottomNavigationView = binding.navView
        navController = findNavController(R.id.nav_host_fragment_activity_main)
        navView.setupWithNavController(navController)

        navView.menu.findItem(R.id.navigation_home).title =
            translatForDialog(this, getString(R.string.nav_home))
        navView.menu.findItem(R.id.navigation_package).title =
            translatForDialog(this, getString(R.string.nav_package))
        navView.menu.findItem(R.id.navigation_usage).title =
            translatForDialog(this, getString(R.string.nav_usage))
        navView.menu.findItem(R.id.navigation_profile).title =
            translatForDialog(this, getString(R.string.nav_profile))
    }


    override fun onBackPressed() {

        when {
            R.id.navigation_home == navController.currentDestination?.id -> {
                finish()
            }

            R.id.navigation_package == navController.currentDestination?.id -> {
                finish()
            }

            R.id.navigation_usage == navController.currentDestination?.id -> {
                finish()
            }

            R.id.navigation_profile == navController.currentDestination?.id -> {
                finish()
            }

            else -> super.onBackPressed()
        }
    }


    companion object {
        fun lunch(context: Context) {
            val intent = Intent(context, MainActivity::class.java)
            intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TASK
            context.startActivity(intent)
        }
    }
}