package com.seatel.mobilehall.ui.login.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.text.TextUtils
import android.util.Log
import android.view.View
import com.seatel.mobilehall.BuildConfig
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.util.customview.ErrorHandleView
import kotlinx.android.synthetic.main.activity_terms_and_conditions.*


class TermsAndConditionsActivity : BaseActivity() {

    private var urlTerm = ":/assets/termsconditions/"

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_terms_and_conditions)
        activityEnterRightAnimation()
        error_view.setViewMode(ErrorHandleView.Mode.LOADING)
        init()

    }

    fun init() {
        var urlWeb = ""
        terms_and_condition.isHorizontalScrollBarEnabled = false

        if (intent.getStringExtra("URLTERM")!!.isNotEmpty()) {
            urlWeb = intent.getStringExtra("URLTERM").toString()
            terms_and_condition.settings.javaScriptEnabled = true
        } else {
            var strUrl = "${BuildConfig.BASE_URL}"
            if (!TextUtils.isEmpty(strUrl))
                strUrl = strUrl.substring(0, strUrl.length - 1)
            urlWeb = "$strUrl$urlTerm"
        }
        Log.d("TAG::>>>", "init: $urlWeb")
        terms_and_condition.loadUrl(urlWeb)
        terms_and_condition.isScrollContainer = false
        error_view.visibility = View.GONE
    }


    override fun getStringToolbarTitle(): String? {
        return getString(R.string.terms_and_condition)
    }

    override fun onBackPressed() {
        super.onBackPressed()
        activityExitLeftAnimation()
    }

    companion object {
        fun launch(context: Context, urlTerm: String = "") {
            val intent = Intent(context, TermsAndConditionsActivity::class.java)
            intent.putExtra("URLTERM", urlTerm)
            context.startActivity(intent)
        }
    }
}
