package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.interactor.ItemViewInteractor
import com.seatel.mobilehall.ui.home.model.SupportedDeviceModel
import kotlinx.android.synthetic.main.support_list_item.view.*

class SupportListAdapter(
    var context: Context,
    var supportedDeviceList: List<SupportedDeviceModel>,
    var onClickItem: ItemViewInteractor
) : BaseAdapter<SupportListAdapter.SupportListVH>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): SupportListVH {
        return SupportListVH(
            LayoutInflater.from(context).inflate(R.layout.support_list_item, parent, false)
        )
    }

    override fun getItemCount(): Int {
        return supportedDeviceList.size
    }

    override fun onBindViewHolder(holder: SupportListVH, position: Int) {
        holder.txtDescription.text = supportedDeviceList[position].brand
        holder.itemView.setOnClickListener {
            onClickItem.onClick(it, position)
        }
    }

    class SupportListVH(view: View) : RecyclerView.ViewHolder(view) {
        val txtDescription = view.text_description

    }
}