package com.seatel.mobilehall.ui.home.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.View
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.interactor.TopupTransactionInteractor
import com.seatel.mobilehall.ui.home.presenter.TopupTransactionPresenter
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.SeatelUtils
import com.seatel.mobilehall.util.customview.ErrorHandleView
import kotlinx.android.synthetic.main.activity_confirmation.*

class ConfirmationActivity : BaseActivity(), TopupTransactionInteractor.View{

    private var mPhoneNumber: String = ""
    private var mAmountTopup: Double = 0.0
    private var isFromPin = false
    private var mPinTopup: String = "0"

    //Topup
    private lateinit var mTopupTransactionPresenter: TopupTransactionPresenter

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        activityEnterFadeInAnimation()
        setContentView(R.layout.activity_confirmation)
        mPhoneNumber = intent.getStringExtra(Constant.PHONE_NUMBER).toString()
        mAmountTopup = intent.getDoubleExtra(Constant.MPAY_AMOUNT, 0.0)
        isFromPin = intent.getBooleanExtra(Constant.LAUNCH_FROM, false)
        mPinTopup = intent.getStringExtra(Constant.PIN_NUMBER).toString()

        mTopupTransactionPresenter = TopupTransactionPresenter(this,this)

        ctv_value_price.text = SeatelUtils.displayAmountNoDecial(this, "$$mAmountTopup")
        ctv_phone_number.text = mPhoneNumber

        image_view_back.setOnClickListener {
            onBackPressed()
        }
        button_ok.setOnClickListener {
            if (isFromPin) {
                error_view.setViewMode(ErrorHandleView.Mode.LOADING)
                mTopupTransactionPresenter.onTopup(
                    mPhoneNumber.replace(" ", ""),
                    mPinTopup,
                    "",
                    "pin",
                    "",
                    "",
                    mAmountTopup
                )
            } else {
//                //Test fixed amount
//                mAmountTopup = 0.01
             //   PaymentActivity.lunch(this, mPhoneNumber, mAmountTopup)
                finish()
            }

            button_ok.isEnabled = false
        }

    }


    override fun onTopupSucceed(paymentType: String, remark: String, amount: Double) {
        TopUpSuccessActivity.lunch(
            this,
            Constant.TOPUP_SUCCESS,
            mAmountTopup.toString(),
            mPhoneNumber
        )
        finish()
    }

    override fun onTopupFailed(error: VolleyError) {
        error_view.visibility = View.GONE
        SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(error)).show()
        button_ok.isEnabled = true
    }

    override fun onBackPressed() {
        super.onBackPressed()
        super.activityExitFadeOutAnimation()

    }

    companion object {
        fun lunch(
            context: Context,
            phoneNumber: String,
            amountTopup: Double,
            fromPin: Boolean,
            pinNumber: String
        ) {
            val intent = Intent(context, ConfirmationActivity::class.java)
            intent.putExtra(Constant.PHONE_NUMBER, phoneNumber)
            intent.putExtra(Constant.MPAY_AMOUNT, amountTopup)
            intent.putExtra(Constant.LAUNCH_FROM, fromPin)
            intent.putExtra(Constant.PIN_NUMBER, pinNumber)
            context.startActivity(intent)
        }
    }

    override fun isDisplayBackgroundBlur(): Boolean {
        return true
    }

    override fun isDisplayToolbar(): Boolean {
        return false
    }
}
