package com.seatel.mobilehall.ui.game

import android.content.Context
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.seatel.mobilehall.data.network.SeatelJSONArrayRequest
import org.json.JSONArray

class GamePresenter(
    private var mContext: Context,
    private var angPaoInteractor: GameInteractor.View
) : GameInteractor.Presenter {


    override fun getGameReward(phoneNumber: String) {
        valentineRequest(phoneNumber).setOnErrorListener { error ->
            angPaoInteractor.onGameRewardFailed(error)
        }.setOnResponseListener { response ->
            angPaoInteractor.onGameRewardSucceed(getResponseValentine(response as JSONArray))
        }.execute()
    }


    private fun getResponseValentine(response: JSONArray): ArrayList<GameModel> {
        val itemType = object : TypeToken<List<GameModel>>() {}.type
        return Gson().fromJson(response.toString(), itemType)
    }


    private fun valentineRequest(phoneNumber: String): SeatelJSONArrayRequest {

        return object : SeatelJSONArrayRequest(mContext) {
            override fun getFunctionName(): String {
                return "v2/seatel/get-prize/$phoneNumber/mystery-box"
            }
        }
    }
}