package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.home.interactor.MyOrderInteractor
import com.seatel.mobilehall.ui.home.model.MyOrderListModel
import com.seatel.mobilehall.ui.home.viewholder.EhubViewHolder
import com.seatel.mobilehall.ui.home.viewholder.MyOrderHeaderIdViewHolder
import com.seatel.mobilehall.ui.home.viewholder.OrderViewHolder

class AdapterParentOrder(
    private var context: Context, private var item1:
    MyOrderListModel, private val isHistory: Boolean, private val mView: MyOrderInteractor.View
) : RecyclerView.Adapter<RecyclerView.ViewHolder>() {

    private val MAX_HOLDER_LENGHT = 1

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            0 -> OrderViewHolder(
                context,
                LayoutInflater.from(context).inflate(R.layout.item_order_view_holder, parent, false)
            )
            1 -> MyOrderHeaderIdViewHolder(
                context,
                LayoutInflater.from(context).inflate(R.layout.item_my_order_header, parent, false)
            )
            else -> EhubViewHolder(
                context,
                LayoutInflater.from(context).inflate(R.layout.item_bottom_ehub, parent, false)
            )
        }
    }

    override fun getItemCount(): Int {
        return MAX_HOLDER_LENGHT
    }

    override fun getItemViewType(position: Int): Int {
        return position
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        when (holder) {
            is OrderViewHolder -> {
                item1.orderData?.let { holder.bind(it, item1, isHistory, mView) }
            }
            is MyOrderHeaderIdViewHolder -> holder.onBind(item1)
            is EhubViewHolder -> {
                holder.onBind()
            }
        }

    }
}