package com.seatel.mobilehall.ui.home.activity

import android.app.Activity
import android.content.Context
import android.content.Intent
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.model.DeviceDetailViewModel
import com.seatel.mobilehall.util.Constant
import com.google.gson.Gson

class DeviceDetailActivity : BaseActivity() {


    companion object {
        fun launch(context: Context, imageUrl: String, model: String) {
            val intent = Intent(context, DeviceDetailActivity::class.java)
            intent.putExtra("imageUrl", imageUrl)
            intent.putExtra("model", model)
            context.startActivity(intent)
        }

        fun lunchWithResult(context: Context, deviceOrder: DeviceDetailViewModel) {
            val intent = Intent(context, DeviceDetailActivity::class.java)
            intent.putExtra(Constant.DATA_DEVICE_DETAIL, Gson().toJson(deviceOrder))
            (context as Activity).startActivityForResult(intent, Constant.CART_DEVICE_DETAIL)
        }
    }

}