package com.seatel.mobilehall.util

import android.app.Dialog
import android.content.Context
import android.graphics.drawable.ColorDrawable
import android.util.TypedValue
import android.view.View
import android.view.ViewGroup
import android.view.Window
import android.widget.ImageView
import android.widget.TextView
import com.seatel.mobilehall.R
import kotlinx.android.synthetic.main.activity_contact_us.*

class AngPavDialog(
    context: Context,
    title: String = "",
    prize: String = "",
    subTitle: String = ""
) : Dialog(context) {

    init {
        init(title, prize, subTitle)
    }


    private fun init(title: String, prize: String, subTitle: String) {
        requestWindowFeature(Window.FEATURE_NO_TITLE)
        setContentView(R.layout.dialog_transparent)
        setCancelable(false)
        if (window != null) {
            window!!.setLayout(
                ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.MATCH_PARENT
            )
            window!!.attributes.windowAnimations = R.style.DialogAnimationScaleInOut
            window!!.setDimAmount(0.5f)
            window!!.setBackgroundDrawable(ColorDrawable(android.graphics.Color.TRANSPARENT))
        }
        val mPrize = findViewById<TextView>(R.id.mPrize)
        val mTitle = findViewById<TextView>(R.id.mTitle)
        mTitle.text = title
        if (prize.isEmpty()) {
            mPrize.visibility = View.GONE
            mTitle.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                context.resources.getDimension(R.dimen.xx_large_text_size)
            )
        } else {
            mPrize.text = prize
        }



        findViewById<TextView>(R.id.mSubTitle).text = subTitle
        findViewById<ImageView>(R.id.iv_close).setOnClickListener {
            dismiss()
        }

    }

}