package com.seatel.mobilehall.ui.home.adapter

import android.app.Activity
import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.activity.FaqDetailActivity
import com.seatel.mobilehall.ui.home.model.FAQModel
import kotlinx.android.synthetic.main.support_list_item.view.*

class RelatedQuestionListAdapter(var context: Context, var relatedQuestionList: List<FAQModel>) :
    BaseAdapter<RelatedQuestionListAdapter.RelatedQuestionVH>() {


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RelatedQuestionVH {
        return RelatedQuestionVH(
            LayoutInflater.from(context).inflate(R.layout.related_question_list_item, parent, false)
        )
    }

    override fun getItemCount(): Int {
        return relatedQuestionList.size
    }

    override fun onBindViewHolder(holder: RelatedQuestionVH, position: Int) {
        holder.txtDescription.text = relatedQuestionList[position].question
        holder.itemView.setOnClickListener {
            (context as Activity).finish()
            FaqDetailActivity.lunch(
                context,
                relatedQuestionList.get(position).id!!,
                relatedQuestionList.get(position).question!!
            )
        }
    }

    class RelatedQuestionVH(view: View) : RecyclerView.ViewHolder(view) {
        val txtDescription = view.text_description
    }
}
