package com.seatel.mobilehall.ui.home.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.adapter.BaseAdapter
import com.seatel.mobilehall.ui.home.activity.FaqDetailActivity
import com.seatel.mobilehall.ui.home.model.FAQModel
import kotlinx.android.synthetic.main.support_list_item.view.*

class FAQsAdapter(var context: Context, var faqList: List<FAQModel>) :
    BaseAdapter<FAQsAdapter.FAQVH>() {


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): FAQVH {
        return FAQVH(
            LayoutInflater.from(context).inflate(R.layout.support_list_item, parent, false)
        )
    }

    override fun getItemCount(): Int {
        return faqList.size
    }

    override fun onBindViewHolder(holder: FAQVH, position: Int) {
        holder.txtDescription.text = faqList[position].question
        holder.itemView.setOnClickListener {
            FaqDetailActivity.lunch(
                context,
                faqList.get(position).id!!,
                faqList.get(position).question!!
            )
        }
    }

    class FAQVH(view: View) : RecyclerView.ViewHolder(view) {
        val txtDescription = view.text_description

    }


}