package com.seatel.mobilehall.ui.game

import android.content.Context
import android.content.Intent
import android.os.Bundle
import android.view.View
import com.android.volley.NoConnectionError
import com.android.volley.Request
import com.android.volley.TimeoutError
import com.android.volley.VolleyError
import com.seatel.mobilehall.R
import com.seatel.mobilehall.data.network.SeatelJSONObjectRequest
import com.seatel.mobilehall.data.network.SeatelSuperRequest
import com.seatel.mobilehall.databinding.LayoutGameRewardBinding
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.util.SeatelAlertDialog
import com.seatel.mobilehall.util.customview.ErrorHandleView
import com.seatel.mobilehall.util.dialogannouncement.CustomGameDialog
import com.seatel.mobilehall.util.viewBinding
import kotlinx.android.synthetic.main.layout_game_reward.error_view
import kotlinx.android.synthetic.main.layout_game_reward.game_recycler
import kotlinx.android.synthetic.main.layout_game_reward.imageViewBack
import org.json.JSONObject

class GameRewardActivity : BaseActivity(), GameInteractor.View {


    private val binding by viewBinding(
        LayoutGameRewardBinding::inflate
    )

    companion object {
        fun launch(context: Context) {
            val intent = Intent(context, GameRewardActivity::class.java)
            context.startActivity(intent)
        }
    }

    private var firstOpen = false


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(binding.root)
        error_view.setViewMode(ErrorHandleView.Mode.LOADING)
        imageViewBack.setOnClickListener {
            onBackPressed()
        }
        firstOpen = true
        GamePresenter(this, this).getGameReward("${getPhoneLogin()}")
    }

    override fun onGameRewardSucceed(angPaoListItem: ArrayList<GameModel>) {
        firstOpen = false
        error_view.visibility = View.GONE
        game_recycler.apply {
            adapter = GameRewardAdapter(this@GameRewardActivity, angPaoListItem) {
                error_view.visibility = View.VISIBLE
                claimPrize(it._id, it.usefor)
            }
        }


    }

    override fun onGameRewardFailed(error: VolleyError) {
        firstOpen = false
        error_view.visibility = View.GONE
        when (error) {
            is TimeoutError -> {
                error_view.errorMessage = getString(R.string.connection_timeout)
                error_view.setViewMode(ErrorHandleView.Mode.TIME_OUT)
            }
            is NoConnectionError -> {
                error_view.errorMessage = getString(R.string.message_no_internet)
                error_view.setViewMode(ErrorHandleView.Mode.NO_INTERNET)
            }
            else -> {
                error_view.errorMessage = getString(R.string.no_data)
                error_view.setViewMode(ErrorHandleView.Mode.NO_DATA)
            }
        }

    }

    private fun claimPrize(id: String, type: String) {
        object : SeatelJSONObjectRequest(this) {
            override fun getFunctionName(): String {
                return "v2/seatel/claim-prize/$id/mystery-box"
            }

            override fun getMethod(): Int {
                return Request.Method.PUT
            }

        }.setOnErrorListener {
            error_view.visibility = View.GONE
            SeatelAlertDialog.with(this, SeatelSuperRequest.getErrorMessageFrom(it)).show()

        }.execute {
            error_view.visibility = View.GONE
            val mTitle = (it as JSONObject).optString("title")
            val mPrize = it.optString("prize")
            val image = it.optString("image")
            val subtitle = it.optString("subtitle")
            val valentineDialog = CustomGameDialog(this, mTitle, mPrize, subtitle, image, true)
            valentineDialog.show()
            valentineDialog.setOnDismissListener {
                onResume()
            }


        }
    }


    override fun onResume() {
        super.onResume()
        if (!firstOpen)
            GamePresenter(this, this).getGameReward("${getPhoneLogin()}")
    }


}