package com.seatel.mobilehall.ui.home.activity

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.graphics.Typeface
import android.os.Bundle
import android.view.Gravity
import android.view.ViewGroup
import android.widget.TextView
import androidx.core.content.ContextCompat
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.base.activity.BaseActivity
import com.seatel.mobilehall.ui.home.adapter.TopUpPagerAdapter
import com.seatel.mobilehall.ui.home.fragment.FullNumberFragment
import com.seatel.mobilehall.ui.home.fragment.LastFourDigitFragment
import com.seatel.mobilehall.ui.home.fragment.PrefixFragment
import com.seatel.mobilehall.util.Constant
import com.seatel.mobilehall.util.FontCache
import com.seatel.mobilehall.util.lang.LanguageManager
import com.seatel.mobilehall.util.manager.OrderingManager
import com.google.android.material.tabs.TabLayout
import kotlinx.android.synthetic.main.activity_buy_yes_number_phase_two.*

@Suppress("NAME_SHADOWING")
class BuyYesNumberPhaseTwoActivity : BaseActivity() {
    private lateinit var mTopUpViewpagerAdapter: TopUpPagerAdapter
    private var lang: String = "en"
    private var fullNumberFragment: FullNumberFragment? = null
    private var prefixFragment: PrefixFragment? = null
    private var lastFourDigitFragment: LastFourDigitFragment? = null
    private var isClaimFreeSim: Boolean = false
    private var isWinPromotionFreeSim: Boolean = false
    private var simCardPriceFilter: Int = -1

    companion object {
        const val REUEST_CODE = 1003
        fun lunch(
            context: Context,
            isClaimFreeSim: Boolean = false,
            simCardPrice: Int = -1,
            isWinPromotionFreeSim: Boolean = false
        ) {
            val intent = Intent(context, BuyYesNumberPhaseTwoActivity::class.java)
            intent.putExtra(Constant.EXTRA_CLAIM_FREE_SIM, isClaimFreeSim)
            intent.putExtra(Constant.EXTRA_WIN_PROMOTION, isWinPromotionFreeSim)
            intent.putExtra(Constant.EXTRA_WIN_PROMOTION_SIMCARTPRICE, simCardPrice)
            context.startActivity(intent)
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_buy_yes_number_phase_two)
        activityEnterRightAnimation()
        init()
//        if (LanguageManager.getInstance(this).getLanguageCode() != null)
//            lang = LanguageManager.getInstance(this).getLanguageCode()!!.toLowerCase()
//        when (lang) {
//            Constant.LangCode.KHMER -> {
//                title_buy_yes_number.textSize = 12f
//
//            }
//    }
    }

    override fun getStringToolbarTitle(): String? {
        return getString(R.string.yes_number)
    }

    private fun init() {
        if (intent.hasExtra(Constant.EXTRA_CLAIM_FREE_SIM))
            isClaimFreeSim = intent.getBooleanExtra(Constant.EXTRA_CLAIM_FREE_SIM, false)
        if (intent.hasExtra(Constant.EXTRA_WIN_PROMOTION))
            isWinPromotionFreeSim =
                intent.getBooleanExtra(Constant.EXTRA_WIN_PROMOTION, false)
        if (intent.hasExtra(Constant.EXTRA_WIN_PROMOTION_SIMCARTPRICE))
            simCardPriceFilter =
                intent.getIntExtra(Constant.EXTRA_WIN_PROMOTION_SIMCARTPRICE, -1)
        tab_layout_buy_yes_number.setupWithViewPager(viewpager_buy_yes_number)
        title_buy_yes_number.text = getString(R.string.full_number)
        val strFullNumber = title_buy_yes_number.text

        title_buy_yes_number.text = getString(R.string.prefix)
        val strPrefix = title_buy_yes_number.text

        title_buy_yes_number.text = getString(R.string.digit)
        val strLastFourDigit = title_buy_yes_number.text
        mTopUpViewpagerAdapter = TopUpPagerAdapter(supportFragmentManager)
        fullNumberFragment = FullNumberFragment()
        prefixFragment = PrefixFragment()
        lastFourDigitFragment = LastFourDigitFragment()

        fullNumberFragment?.setClaimFreeSim(isClaimFreeSim)
        prefixFragment?.setClaimFreeSim(isClaimFreeSim)
        lastFourDigitFragment?.setClaimFreeSim(isClaimFreeSim)

        fullNumberFragment?.setIsWinPromotionFreeSim(isWinPromotionFreeSim)
        prefixFragment?.setIsWinPromotionFreeSim(isWinPromotionFreeSim)
        lastFourDigitFragment?.setIsWinPromotionFreeSim(isWinPromotionFreeSim)

        if (isWinPromotionFreeSim) {
            fullNumberFragment?.setSimCardPriceFilter(simCardPriceFilter)
            prefixFragment?.setSimCardPriceFilter(simCardPriceFilter)
            lastFourDigitFragment?.setSimCardPriceFilter(simCardPriceFilter)
        }

        mTopUpViewpagerAdapter.addFragment(fullNumberFragment!!, strFullNumber as String)
        mTopUpViewpagerAdapter.addFragment(prefixFragment!!, strPrefix as String)
        mTopUpViewpagerAdapter.addFragment(lastFourDigitFragment!!, strLastFourDigit as String)
        viewpager_buy_yes_number.adapter = mTopUpViewpagerAdapter
        viewpager_buy_yes_number.offscreenPageLimit = 3
        setTabTextStyle()
    }

    override fun onBackPressed() {
//        if (tab_layout_buy_yes_number.selectedTabPosition == 0) {
//            if (fullNumberFragment!!.isKeyboardHided()) {
//                super.onBackPressed()
//                activityExitLeftAnimation()
//            } else {
//                fullNumberFragment?.hideKeyBoard()
//                fullNumberFragment?.updateUiAfterItemSelected()
//            }
//        } else {
//            if (tab_layout_buy_yes_number.selectedTabPosition == 1) {
//                viewpager_buy_yes_number.setCurrentItem(0, false)
//            } else if (tab_layout_buy_yes_number.selectedTabPosition == 2) {
//                if (lastFourDigitFragment!!.isKeyboardHided()) {
//                    viewpager_buy_yes_number.setCurrentItem(0, false)
//                } else {
//                    lastFourDigitFragment?.hideKeyBoard()
//                    lastFourDigitFragment?.updateUiAfterItemSelected()
//                }
//
//            }
//        }
        OrderingManager.getInstance().setPromotionItem("")
        super.onBackPressed()
        activityExitLeftAnimation()
    }

    private fun setTabTextStyle() {

        val font = FontCache.getFont(this@BuyYesNumberPhaseTwoActivity, Typeface.NORMAL)
        val tf = FontCache.get(this@BuyYesNumberPhaseTwoActivity, font)

        for (i in 0 until tab_layout_buy_yes_number.tabCount) {
            val tab = tab_layout_buy_yes_number.getTabAt(i)

            if (tab != null) {
                val tabTextView = TextView(this)
                tab.customView = tabTextView
                tabTextView.layoutParams.width = ViewGroup.LayoutParams.WRAP_CONTENT
                tabTextView.layoutParams.height = ViewGroup.LayoutParams.WRAP_CONTENT
                tabTextView.text = tab.text
                tabTextView.gravity = Gravity.CENTER
                if (LanguageManager.getInstance(this).getLanguageCode() != null)
                    lang = LanguageManager.getInstance(this).getLanguageCode()!!.toLowerCase()
                when (lang) {
                    Constant.KHMER -> {
                        tabTextView.textSize = 14f

                    }
                    else -> {
                        tabTextView.textSize = 16F
                    }
                }

                tabTextView.setTypeface(tf, Typeface.NORMAL)

                tabTextView.setTextColor(ContextCompat.getColor(this, android.R.color.white))
                // First tab is the selected tab, so if i==0 then set BOLD typeface
                if (i == 0) {
                    val fontBold =
                        FontCache.getFont(this@BuyYesNumberPhaseTwoActivity, Typeface.BOLD)
                    val bold = FontCache.get(this@BuyYesNumberPhaseTwoActivity, fontBold)
                    tabTextView.setTypeface(bold, Typeface.BOLD)
                }
            }
        }
        tab_layout_buy_yes_number.addOnTabSelectedListener(object :
            TabLayout.OnTabSelectedListener {

            override fun onTabSelected(tab: TabLayout.Tab) {
                viewpager_buy_yes_number.currentItem = tab.position
                val text = tab.customView as TextView?
                val font = FontCache.getFont(this@BuyYesNumberPhaseTwoActivity, Typeface.BOLD)
                text!!.setTypeface(
                    FontCache.get(this@BuyYesNumberPhaseTwoActivity, font),
                    Typeface.BOLD
                )
            }

            override fun onTabUnselected(tab: TabLayout.Tab) {
                val text = tab.customView as TextView?
                val font = FontCache.getFont(this@BuyYesNumberPhaseTwoActivity, Typeface.NORMAL)
                text!!.setTypeface(
                    FontCache.get(this@BuyYesNumberPhaseTwoActivity, font),
                    Typeface.NORMAL
                )
            }

            override fun onTabReselected(tab: TabLayout.Tab) {

            }
        })
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (resultCode == Activity.RESULT_OK && requestCode == BuyYesNumberPhaseTwoActivity.REUEST_CODE) {
            val isCard = data?.getBooleanExtra(Constant.EXTRA_IS_CART, false)
            if (isCard != null && isCard) {
                MyCartActivity.launch(this)
            }
            finish()
        }
    }


}
