package com.seatel.mobilehall.ui.home.fragment

import android.Manifest
import android.annotation.SuppressLint
import android.app.Activity
import android.app.Dialog
import android.content.Intent
import android.content.pm.PackageManager
import android.net.Uri
import android.os.Build
import android.view.View
import androidx.annotation.RequiresApi
import androidx.coordinatorlayout.widget.CoordinatorLayout
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.seatel.mobilehall.R
import com.seatel.mobilehall.ui.profile.interactor.BottomSheetInteractor
import com.seatel.mobilehall.util.PermissionUtil
import kotlinx.android.synthetic.main.dialog_support.view.*


class SupportBottomSheetFragment : BottomSheetDialogFragment(), View.OnClickListener {
    private var mParams: CoordinatorLayout.LayoutParams? = null
    private lateinit var bottomSheetBehavior: BottomSheetBehavior<*>
    private lateinit var mBottomSheetView: BottomSheetInteractor.View
    private var strPhone = "1800"
    private lateinit var mPhoneNumberRequest: PermissionUtil.PermissionRequestObject

    private val mBottomSheetBehaviorCallback = object : BottomSheetBehavior.BottomSheetCallback() {

        override fun onStateChanged(bottomSheet: View, newState: Int) {
            if (newState == BottomSheetBehavior.STATE_HIDDEN)
                dismiss()
        }

        override fun onSlide(bottomSheet: View, slideOffset: Float) {}
    }

    fun setBottomSheetView(bottomSheetView: BottomSheetInteractor.View) {
        this.mBottomSheetView = bottomSheetView
    }

//    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?,
//                              savedInstanceState: Bundle?): View? {
//        // Inflate the layout for this fragment
//        return inflater.inflate(R.layout.fragment_bottom_sheet, container, false)
//    }

    @SuppressLint("RestrictedApi")
    override fun setupDialog(dialog: Dialog, style: Int) {

        super.setupDialog(dialog, style)
        val view = View.inflate(context, R.layout.dialog_support, null)
        dialog.setContentView(view)

        if (mParams == null) {
            mParams = (view.parent as View).layoutParams as CoordinatorLayout.LayoutParams
        }

        val behavior = mParams!!.behavior
        (view.parent as View).setBackgroundColor(resources.getColor(android.R.color.transparent))
        bottomSheetBehavior = BottomSheetBehavior.from<View>(view.root_layout)


        if (behavior != null && behavior is BottomSheetBehavior<*>) {
            bottomSheetBehavior.setBottomSheetCallback(mBottomSheetBehaviorCallback)
        }

        //  view.parent_camera.setOnClickListener { mBottomSheetView.onCameraClicked() }
        // view.parent_gallery.setOnClickListener { mBottomSheetView.onGalleryClicked() }

        view.ctv_call1800.setOnClickListener(this)
        view.ctv_call018.setOnClickListener(this)
        view.ctv_website.setOnClickListener(this)
        view.parent_facebook.setOnClickListener(this)
        view.parent_messenger.setOnClickListener(this)

        view.button_cancel.setOnClickListener {
            bottomSheetBehavior.state = BottomSheetBehavior.STATE_HIDDEN
        }
    }

    @RequiresApi(Build.VERSION_CODES.P)
    override fun onClick(v: View?) {
        if (v == null)
            return
        when (v.id) {
            R.id.ctv_call1800 -> {
                strPhone = "1800"
                showCallDialog()
            }

            R.id.ctv_call018 -> {
                strPhone = "855189800800"
                showCallDialog()
            }

            R.id.ctv_website -> {
                val intent = Intent(Intent.ACTION_VIEW)
                intent.data = Uri.parse("https://www.yes.com.kh")
                startActivity(intent)
            }

            R.id.parent_facebook -> {

            }

            R.id.parent_messenger -> {
                try {
                    val intent =
                        Intent(Intent.ACTION_VIEW, Uri.parse("fb-messenger://user/827306730678321"))
                    startActivity(intent)
                } catch (e: Exception) {
                    val intent = Intent(Intent.ACTION_VIEW, Uri.parse("https://m.me/yes kh"))
                    startActivity(intent)
                }
            }
        }
    }

    private fun showCallDialog() {
        if (ContextCompat.checkSelfPermission(
                requireContext(),
                Manifest.permission.CALL_PHONE
            ) != PackageManager.PERMISSION_GRANTED
        ) {
            showCallDialScreenPhone()
        } else {
            requestPermissionLocation()
            ActivityCompat.requestPermissions(
                this as Activity,
                arrayOf(Manifest.permission.CALL_PHONE),
                com.seatel.mobilehall.util.Constant.REQUEST_PHONE_CALL
            )
        }
    }


    private fun showCallDialScreenPhone() {
        val intent = Intent(Intent.ACTION_DIAL)
        intent.data = Uri.parse("tel:$strPhone")
        startActivity(intent)
    }


    private fun requestPermissionLocation() {
        mPhoneNumberRequest = com.seatel.mobilehall.util.PermissionUtil.with(this)
            .request(Manifest.permission.CALL_PHONE)
            .onAllGranted(object : com.seatel.mobilehall.util.PermissionUtil.Func() {
                override fun call() {
                    showCallDialScreenPhone()
                }
            }).onAnyDenied(object : com.seatel.mobilehall.util.PermissionUtil.Func() {
                override fun call() {

                }
            })
            .askPermission(com.seatel.mobilehall.util.Constant.REQUEST_LOCATION_PERMISSION_CODE)
    }


}
